<?php

namespace FrontBundle\Listener;

use AppBundle\Entity\Order;
use AppBundle\Entity\RefOrderStatus;
use AppBundle\Entity\Transaction;
use Doctrine\Common\Persistence\ObjectManager;
use Lexik\Bundle\PayboxBundle\Event\PayboxResponseEvent;
use Symfony\Component\HttpFoundation\RequestStack;
class PayboxResponseListener
{
    private $manager;

    public function __construct(ObjectManager $manager)
    {
        $this->manager = $manager;
    }
    /**
     * Update the database for the given donation with the Paybox data.
     *
     * @param PayboxResponseEvent $event
     */
    public function onPayboxIpnResponse(PayboxResponseEvent $event)
    {
        if (!$event->isVerified()) {
            return;
        }
        $payboxPayload = $event->getData();
        if (!isset($payboxPayload['id'], $payboxPayload['authorization'], $payboxPayload['result'])) {
            return;
        }
        $id = explode('_', $payboxPayload['id'])[0];
        $donation = $this->manager->getRepository(Order::class)->findOneBy([
            'id' => $id
        ]);
        if (!$donation) {
            return;
        }

        if($payboxPayload['result'] == 00000)
        {
            $status = $this->manager->getRepository(RefOrderStatus::class)->findOneBy([
                'id' => 3
            ]);
            $donation->setStatus($status);

            $this->manager->persist($donation);
            $this->manager->flush();
        }

        if($donation->getTransaction())
        {
            $transaction = $donation->getTransaction();
        }
        else{
            $transaction = new Transaction();
        }

        $transaction->setOrder($donation)
            ->setResult($payboxPayload['result'])
            ->setTransaction($payboxPayload['transaction'])
            ->setAmount($payboxPayload['amount'])
            ->setDate($payboxPayload['date'])
            ->setTime($payboxPayload['time'])
            ->setCardType($payboxPayload['card_type'])
            ->setCardEnd($payboxPayload['card_end'])
        ;

        $this->manager->persist($transaction);
        $this->manager->flush();

    }
}