<?php

namespace FrontBundle\Form;

use AppBundle\Entity\Erp;
use AppBundle\Entity\PrintRequest;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\NumberType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Validator\Constraints\NotBlank;

class PrintRequestType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('printer', EntityType::class, [
                'class' => 'AppBundle:RefPrinter',
                'choice_label' => 'name',
                'placeholder' => 'Choisissez un imprimeur',
                'label' => 'Imprimeur',
                'required' => true,
                'constraints' => [
                    new NotBlank()
                ]
            ])
            ->add('save', SubmitType::class, [
                'label' => 'Transmettre les documents à l\'imprimeur',
                'attr' => [
                    'class' => 'btn-primary'
                ],
            ])
        ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => PrintRequest::class,
        ));
    }
}