<?php

namespace FrontBundle\Form;

use AppBundle\Entity\AccessibilityRegister;
use AppBundle\Entity\FileUpload;
use AppBundle\Entity\RefTypeFile;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\IntegerType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormEvents;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\FileType;

class FileUploadType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('file_uploaded', FileType::class, [
                'label' => $options['type']->getLabel(),
                'mapped' => false,
                'required' => false
            ])
            ->add('file_type_id', HiddenType::class, [
                'data' => $options['type']->getId(),
                'mapped' => false
            ]);

        $builder->addEventListener(FormEvents::PRE_SUBMIT, function(FormEvent $event) use ($options){
            $data = $event->getData();
            $form = $event->getForm();

            $form->add('name', TextType::class);
            $form->add('path', TextType::class);

            $event->setData($data);

        });
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => FileUpload::class
        ));
        $resolver->setRequired(array(
            'type',
            'types',
        ));
    }
}