<?php

namespace FrontBundle\Form;

use AppBundle\Entity\Erp;
use AppBundle\Validator\Constraints\Luhn;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\NumberType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Validator\Constraints\NotBlank;

class ErpType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('name', TextType::class, [
                'label' => 'Nom de l\'établissement',
                'required' => true,
                'constraints' => [
                    new NotBlank()
                ]
            ])
            ->add('siret', TextType::class, [
                'label' => 'N° de SIRET',
                'required' => true,
                'constraints' => [
                    new NotBlank(),
                    new Luhn()
                ]
            ])
            ->add('categoryErp', EntityType::class, [
                'class' => 'AppBundle:RefCategoryErp',
                'choice_label' => 'label',
                'placeholder' => 'Choisissez une catégorie',
                'label' => 'Catégorie d\'ERP',
                'required' => true,
                'constraints' => [
                    new NotBlank()
                ]
            ])
            ->add('typeErp', EntityType::class, [
                'class' => 'AppBundle:RefTypeErp',
                'choice_label' => 'label',
                'placeholder' => 'Choisissez un type',
                'label' => 'Type d\'ERP',
                'required' => true,
                'constraints' => [
                    new NotBlank()
                ]
            ])
            ->add('address_1', TextType::class, [
                'label' => 'Adresse',
                'required' => true,
                'constraints' => [
                    new NotBlank()
                ]
            ])
            ->add('address_2', TextType::class, [
                'label' => 'Adresse (complémentaire)',
                'required' => false,
            ])
            ->add('postal_code', NumberType::class, [
                'label' => 'Code postal',
                'required' => true,
                'constraints' => [
                    new NotBlank()
                ]
            ])
            ->add('city', TextType::class, [
                'label' => 'Ville',
                'required' => true,
                'constraints' => [
                    new NotBlank()
                ]
            ])
            ->add('save', SubmitType::class, array('label' => 'Enregistrer l\'établissement'))
        ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => Erp::class,
        ));
    }
}