<?php

namespace FrontBundle\Form;

use AppBundle\Entity\AccessibilityRegister;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Validator\Constraints\NotBlank;

class AccessibilityRegisterType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder

            ->add('files', FileUploadType::class, [
                'types' => $options['types'],
                'label' => 'Pièces administratives'
            ])
            ->add('save', SubmitType::class, array('label' => 'Enregistrer le registre'))
        ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => AccessibilityRegister::class,
        ));
        $resolver->setRequired(array(
            'types'
        ));
    }
}