<?php

namespace FrontBundle\Controller;

use AppBundle\Entity\User;
use FrontBundle\Form\EditUserInfoType;
use FrontBundle\Form\EditUserPasswordType;
use FrontBundle\Form\UserType;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Security\Core\Encoder\UserPasswordEncoderInterface;

class UserController extends Controller
{

    /**
     * @Route("/dashboard/user/edit", name="user_edit")
     */
    public function userEditAction(Request $request, UserPasswordEncoderInterface $passwordEncoder)
    {

        $user = $this->getDoctrine()->getRepository(User::class)->findOneBy([
            'id' => $this->getUser()->getId()
        ]);



        # GENERAL INFORMATIONS
        $form = $this->createForm(EditUserInfoType::class, $user);

        $form->handleRequest($request);
        if ($form->isSubmitted() && $form->isValid()) {

            $em = $this->getDoctrine()->getManager();
            $em->persist($user);
            $em->flush();

            $this->addFlash('notice', 'Votre compte a bien été modifié');
            $this->redirectToRoute('user_edit');
        }


        # PASSWORD
        $form_password = $this->createForm(EditUserPasswordType::class, $user);

        $form_password->handleRequest($request);
        if ($form_password->isSubmitted() && $form_password->isValid()) {

            $em = $this->getDoctrine()->getManager();

            if($form_password->get('oldPassword')->getData())
            {
                $oldPasswordField = $form_password->get('oldPassword')->getData();
                $match = $passwordEncoder->isPasswordValid($this->getUser(), $oldPasswordField);

                if($match)
                {

                    $password = $passwordEncoder->encodePassword($this->getUser(), $user->getPlainPassword());
                    $user->setPassword($password);

                    $em->persist($user);
                    $em->flush();

                    $this->addFlash('notice', 'Votre mot de passe a bien été modifié');
                }
                else
                {
                    $this->addFlash('notice', "Votre ancien mot de passe n'est pas correct.");
                }

                $this->redirectToRoute('user_edit');
            }

        }


        return $this->render('Front/Dashboard/account/edit.html.twig', [
            'form' => $form->createView(),
            'form_password' => $form_password->createView()
        ]);
    }


}
