<?php

namespace FrontBundle\Controller;

use AppBundle\Entity\AccessibilityRegister;
use AppBundle\Entity\Erp;
use AppBundle\Entity\QrCode;
use AppBundle\Service\MailManager;
use Doctrine\DBAL\Types\TextType;
use FrontBundle\Form\ContactType;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\Form\Extension\Core\Type\EmailType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\TextareaType;
use Symfony\Component\HttpFoundation\Request;

class SiteAccessibleController extends Controller
{

    /**
     * @Route("/qrcode-redirect/{hash}", name="qrCode_redirect", host="%site_accessible_domain%")
     */
    public function qrCodeRedirectAction(Request $request, $hash)
    {
        $qrCode = $this->getDoctrine()->getRepository(QrCode::class)->findOneBy([
            'hash' => $hash
        ]);
        if($qrCode) {
            if($qrCode->getRegister()) {
                $register = $qrCode->getRegister();
                if($register->getErp()) {
                    $erp = $register->getErp();
                    return $this->redirectToRoute('siteAccessible_view', [
                        'erp_slug' => $erp->getSlug()
                    ]);
                }
            }
        }
        return $this->redirectToRoute('homepage');
    }


    /**
     * @Route("/etablissement/{erp_slug}", name="siteAccessible_view", host="%site_accessible_domain%")
     */
    public function siteAccessibleViewAction(Request $request, $erp_slug, MailManager $mailManager)
    {

        $erp = $this->getDoctrine()->getRepository(Erp::class)->findOneBy([
            'slug' => $erp_slug
        ]);


        $register = $this->getDoctrine()->getRepository(AccessibilityRegister::class)
            ->findOnePublicVersionRegister($erp);

        $types = null;
        $fileUploads = null;

        if($register){
            $types = $register->getErp()->getCategoryErp()->getTypesFile();
            $fileUploads = [];
            foreach($types as $type) {
                $fileUploads[$type->getId()] = $register->getFileUploadsByTypeId($type->getId());
            }
        }

        $form = $this->createForm(ContactType::class, null, [
            'action' => $this->generateUrl('siteAccessible_view', ['erp_slug' => $erp_slug]),
            'method' => 'POST'
        ]);

        $form->handleRequest($request);
        if ($form->isSubmitted() && $form->isValid()) {


            # Envoi du mail pour le client
            $users = $erp->getCompany()->getUsers();
            foreach($users as $user)
            {
                $userLinked = $user;
                break;
            }

            $mailManager->sendErpContactEmail($userLinked, $erp, $form->getData());

            $this->addFlash('notice', 'Votre message a bien été envoyé.');
            return $this->redirectToRoute('siteAccessible_view', ['erp_slug' => $erp->getSlug()]);

        }

        return $this->render('Front/SiteAccessible/view.html.twig', [
            'erp' => $erp,
            'register' => $register,
            'types' => $types,
            'fileUploads' => $fileUploads,
            'contactForm' => $form->createView()
        ]);
    }

}
