<?php

namespace FrontBundle\Controller;

use AppBundle\Entity\User;
use AppBundle\Service\MailManager;
use FrontBundle\Form\ForgotPasswordType;
use FrontBundle\Form\NewPasswordType;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\Security\Http\Authentication\AuthenticationUtils;
use Symfony\Component\Security\Core\Encoder\UserPasswordEncoderInterface;

class SecurityController extends Controller
{
    /**
     * @Route("/app/login", name="app_login", host="%domain%")
     */
    public function loginAction()
    {
        $helper = $this->get('security.authentication_utils');
        return $this->render('security/login.html.twig', [
            'last_username' => $helper->getLastUsername(),
            'error' => $helper->getLastAuthenticationError(),
        ]);
    }

    /**
     * @Route("/app/check", name="app_check")
     */
    public function checkAction()
    {
    }

    /**
     * @Route("/app/logout", name="app_logout")
     */
    public function logoutAction()
    {

    }

    /**
     * @Route("/app/forgot-password", name="app_forgot_password", host="%domain%")
     */
    public function forgotPasswordAction(Request $request, MailManager $mailManager)
    {
        $form = $this->createForm(ForgotPasswordType::class);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid())
        {
            $utilisateur = $this->getDoctrine()->getRepository(User::class)
                ->findOneBy([
                    'email' => $form['username']->getData(),
                    'statut' => User::STATUT_ACTIF,
                ]);

            if($utilisateur)
            {

                $chars = "abcdefghkmnprstuvwxyzABCDEFGHKMNPRSTUVWXYZ23456789";
                $token = substr(str_shuffle($chars), 0, 16);

                $utilisateur->setToken($token);

                $em = $this->getDoctrine()->getManager();
                $em->persist($utilisateur);
                $em->flush();

                $mailManager->sendUserForgotPasswordEmail($utilisateur, $token);

            }

            $this->addFlash('notice', 'Si l\'adresse email saisie est valide, un email vous a été envoyé pour réinitialiser votre mot de passe.');
            return $this->redirectToRoute('app_login');

        }

        return $this->render('security/forgot_password.html.twig', [
            'form' => $form->createView()
        ]);
    }

    /**
     * @Route("/app/new-password/{token}/{username}", name="app_new_password", host="%domain%")
     */
    public function newPasswordAction(Request $request, $token, $username, UserPasswordEncoderInterface $encoder)
    {
        $utilisateur = $this->getDoctrine()->getRepository(User::class)
            ->findOneBy([
                'email' => $username,
                'token' => $token,
            ]);

        if($utilisateur)
        {
            $form = $this->createForm(NewPasswordType::class, $utilisateur);


            if($request->isMethod('POST'))
            {
                $form->submit($request->request->get('new_password'));

                if($form->isValid())
                {
                    $utilisateur = $form->getData();
                    $em = $this->getDoctrine()->getManager();

                    $utilisateur->setToken(null);

                    $plainPassword = $form->get('plainPassword')->getData();
                    $encoded = $encoder->encodePassword($utilisateur, $plainPassword);
                    $utilisateur->setPassword($encoded);

                    $em->persist($utilisateur);
                    $em->flush();

                    $this->addFlash('notice', 'Votre mot de passe a été réinitialisé');
                    return $this->redirect( $this->generateUrl('app_login' ));
                }
            }

            return $this->render('security/new_password.html.twig', [
                'form' => $form->createView()
            ]);
        }

        return $this->redirect( $this->generateUrl('homepage' ));

    }

}