<?php

namespace FrontBundle\Controller;

use AppBundle\Entity\Company;
use AppBundle\Service\MailManager;
use FrontBundle\Form\UserType;
use AppBundle\Entity\User;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\Security\Core\Encoder\UserPasswordEncoderInterface;

class RegistrationController extends Controller
{
    /**
     * @Route("/app/register", name="app_register")
     */
    public function registerAction(Request $request, UserPasswordEncoderInterface $passwordEncoder, MailManager $mailManager)
    {
        $user = new User();
        $form = $this->createForm(UserType::class, $user);

        $form->handleRequest($request);
        if ($form->isSubmitted() && $form->isValid()) {

            if(!empty($request->request->get('user')['codeParrain'])){
                $code = $request->request->get('user')['codeParrain'];
                $parrain = $this->getDoctrine()->getRepository(Company::class)->findOneBy([
                    'code_parrainage' => $code
                ]);
                if($parrain){
                    $company = $user->getCompany();
                    $company->setParrain($parrain);
                }
            }

            $password = $passwordEncoder->encodePassword($user, $user->getPlainPassword());
            $user->setPassword($password);
            $user->setRole('ROLE_USER');
            $user->setStatut('disabled');
            $user->getCompany()->setRole('standard');


            $chars = "abcdefghkmnprstuvwxyzABCDEFGHKMNPRSTUVWXYZ23456789";
            $token = substr(str_shuffle($chars), 0, 16);
            $user->setToken($token);

            $mailManager->sendUserConfirmationEmail($user, $token);
            $mailManager->sendRegistrationNotificationEmail($user);

            $em = $this->getDoctrine()->getManager();
            $em->persist($user);
            $em->flush();

            $this->addFlash('notice', 'Votre compte a été créé, cependant, pour valider votre adresse email, merci de cliquer sur le lien que nous venons de vous envoyer.');

            return $this->redirectToRoute('account_to_validate');
        }

        return $this->render(
            'security/register.html.twig',
            array('form' => $form->createView())
        );
    }

    /**
     * @Route("/account-to-validate", name="account_to_validate")
     */
    public function accountToValidateAction()
    {
        return $this->render('security/account_to_validate.html.twig');
    }

    /**
     * @Route("/check-email/{token}/{email}", name="app_check_email")
     */
    public function checkEmailAction($email, $token)
    {
        $user = $this->getDoctrine()->getRepository(User::class)
            ->findOneBy([
                'email' => $email,
                'token' => $token,
            ]);

        if($user)
        {
            $user->setStatut('enabled');
            $user->setToken(null);

            $em = $this->getDoctrine()->getManager();
            $em->persist($user);
            $em->flush();
            $this->addFlash('notice', 'Votre compte a bien été validé, vous pouvez désormais vous connecter avec vos identifiants.');
            return $this->redirectToRoute('app_login', ['user' => $user->getEmail()]);
        }
        else
        {
            return $this->redirectToRoute('homepage');
        }
    }

}