<?php

namespace FrontBundle\Controller;

use AppBundle\Entity\AccessibilityRegister;
use AppBundle\Entity\BonusParrainage;
use AppBundle\Entity\Erp;
use AppBundle\Entity\Exchange;
use AppBundle\Entity\Invoice;
use AppBundle\Entity\NavigationMenu;
use AppBundle\Entity\Order;
use AppBundle\Entity\Post;
use AppBundle\Entity\PrintRequest;
use AppBundle\Entity\RefPrintStatus;
use AppBundle\Entity\SiteAccessibleSearchHistory;
use AppBundle\Service\AccessManager;
use AppBundle\Service\MailManager;
use AppBundle\Service\QrCodeGenerator;
use Endroid\QrCode\QrCode;
use FrontBundle\Form\ContactType;
use Spipu\Html2Pdf\Html2Pdf;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpKernel\Exception\AccessDeniedHttpException;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;

class ParrainageController extends Controller
{

    /**
     * @Route("/dashboard/parrainage/send", name="parrainage_send")
     */
    public function parrainageSendAction(Request $request, MailManager $mailManager)
    {
        if(!$this->getUser()->getCompany()->getCodeParrainage()){
            $this->addFlash('danger', 'Vous ne pouvez pas accéder à cette page.');
            return $this->redirectToRoute('dashboard_index');
        }

        if(!empty($request->request->get('parrainage'))){
            $filleuls = $request->request->get('parrainage');
            foreach($filleuls as $filleul)
            {
                $mailManager->sendParrainageEmail($filleul, $this->getUser());
            }
            $this->addFlash('success', 'Les demandes ont bien été envoyées');
            return $this->redirectToRoute('parrainage_send');
        }

        return $this->render('Front/Dashboard/parrainage/send.html.twig', [
        ]);
    }

    /**
     * @Route("/dashboard/parrainage/list", name="parrainage_list")
     */
    public function parrainageListAction(Request $request)
    {
        if(!$this->getUser()->getCompany()->getCodeParrainage()){
            $this->addFlash('danger', 'Vous ne pouvez pas accéder à cette page.');
            return $this->redirectToRoute('dashboard_index');
        }

        $has_filleuls = false;
        foreach($this->getUser()->getCompany()->getFilleuls() as $filleul)
        {
            $has_filleuls = true;
            break;
        }
        if(!$has_filleuls){
            $this->addFlash('danger', 'Vous ne pouvez pas accéder à cette page.');
            return $this->redirectToRoute('dashboard_index');
        }

        $bonus = $this->getDoctrine()->getRepository(BonusParrainage::class)->findByParrain($this->getUser()->getCompany());

        return $this->render('Front/Dashboard/parrainage/list.html.twig', [
            'bonusList' => $bonus
        ]);
    }

    /**
     * @Route("/dashboard/parrainage/bonus", name="parrainage_bonus")
     */
    public function parrainageBonusAction(Request $request)
    {
        $has_filleuls = false;
        foreach($this->getUser()->getCompany()->getFilleuls() as $filleul)
        {
            $has_filleuls = true;
            break;
        }
        if(!$has_filleuls){
            $this->addFlash('danger', 'Vous ne pouvez pas accéder à cette page.');
            return $this->redirectToRoute('dashboard_index');
        }

        $erps = $this->getDoctrine()->getRepository(Erp::class)->findBy([
            'company' => $this->getUser()->getCompany()
        ]);

        $bonus = $this->getDoctrine()->getRepository(BonusParrainage::class)->findBy([
            'parrain' => $this->getUser()->getCompany(), 'activated_at' => null
        ]);

        if(!$bonus){
            $this->addFlash('danger', 'Vous ne pouvez pas accéder à cette page.');
            return $this->redirectToRoute('dashboard_index');
        }

        $erps_eligible = [];
        foreach($erps as $erp){
            if($erp->getSubscriptions()){
                foreach($erp->getSubscriptions() as $subscription){
                    if($subscription->isValid()){
                        $erps_eligible[] = $erp;
                        break;
                    }
                }
            }
        }

        return $this->render('Front/Dashboard/parrainage/bonus.html.twig', [
            'erps' => $erps_eligible,
            'bonusList' => $bonus
        ]);
    }

    /**
     * @Route("/dashboard/parrainage/bonus/{erp_id}/{bonus_id}", name="parrainage_bonus_choose")
     */
    public function parrainageBonusChooseAction(Request $request, $erp_id, $bonus_id, AccessManager $accessManager)
    {

        $erp = $this->getDoctrine()->getRepository(Erp::class)->findOneBy(['id' => $erp_id]);

        if(!$accessManager->checkUserbyErp($this->getUser(), $erp))
        {
            throw new AccessDeniedHttpException('Vous ne pouvez pas activer le bonus.');
        }

        $has_filleuls = false;
        foreach($this->getUser()->getCompany()->getFilleuls() as $filleul)
        {
            $has_filleuls = true;
            break;
        }
        if(!$has_filleuls){
            $this->addFlash('danger', 'Vous ne pouvez pas accéder à cette page.');
            return $this->redirectToRoute('dashboard_index');
        }

        $bonus = $this->getDoctrine()->getRepository(BonusParrainage::class)->findOneBy(['id' => $bonus_id]);

        if($bonus->getActivatedAt()){
            $this->addFlash('warning', 'Le bonus a déjà été utilisé.');
            return $this->redirectToRoute('dashboard_index');
        }

        $eligible = false;
        $subscriptionToAccurate = null;
        if($erp->getSubscriptions()){
            foreach($erp->getSubscriptions() as $subscription){
                if($subscription->isValid()){
                    $eligible = true;
                    $subscriptionToAccurate = $subscription;
                    break;
                }
            }
        }

        if(!$eligible){
            $this->addFlash('warning', 'Votre établissement n\'est pas éligible à recevoir ce bonus');
            return $this->redirectToRoute('dashboard_index');
        }

        $bonus->setErpBeneficiary($erp)
            ->setActivatedAt(new \DateTime());


        $dateEnd = $subscriptionToAccurate->getDateEnd()->format('Y-m-d H:i:s');
        $date = date_create($dateEnd);
        $date->modify('+1 year');
        $subscriptionToAccurate->setDateEnd($date);

        $em = $this->getDoctrine()->getManager();
        $em->persist($bonus);
        $em->persist($subscriptionToAccurate);
        $em->flush();

        $this->addFlash('success', "L'année d'hébergement a bien été ajoutée à l'établissement ".$erp->getName());
        return $this->redirectToRoute('dashboard_index');
    }

}
