<?php

namespace FrontBundle\Controller;

use AppBundle\Entity\AccessibilityRegister;
use AppBundle\Entity\Erp;
use AppBundle\Entity\FileUpload;
use AppBundle\Service\AccessManager;
use AppBundle\Service\FileUploader;
use FrontBundle\Form\AccessibilityRegisterType;
use FrontBundle\Form\FileUploadType;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\BinaryFileResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpKernel\Exception\AccessDeniedHttpException;

class FileUploadController extends Controller
{

    /**
     * @Route("/dashboard/file/delete/{file_id}/{register_id}", name="file_delete")
     */
    public function fileDeleteAction($file_id, $register_id, AccessManager $accessManager)
    {

        $file = $this->getDoctrine()->getRepository(FileUpload::class)->findOneBy([
            'id' => $file_id
        ]);

        $register = $this->getDoctrine()->getRepository(AccessibilityRegister::class)->findOneBy([
            'id' => $register_id
        ]);

        if(!$accessManager->checkUserbyFileUpload($this->getUser(), $file))
        {
            throw new AccessDeniedHttpException("Vous n'avez pas l'autorisation de supprimer ce fichier.");
        }

        $register->setUpdatedAt(new \DateTime());

        $em = $this->getDoctrine()->getEntityManager();
        $register->removeFileUpload($file);
        $file->removeAccessibilityRegister($register);

        $em->persist($register);
        $em->flush();

        return $this->redirectToRoute('register_edit', [
            'register_id' => $register->getId()
        ]);
    }

    /**
     * @Route("/dashboard/file/view/{file_id}", name="file_view")
     */
    public function fileViewAction($file_id, AccessManager $accessManager)
    {

        $file = $this->getDoctrine()->getRepository(FileUpload::class)->findOneBy([
            'id' => $file_id
        ]);

        if(!$accessManager->checkUserbyFileUpload($this->getUser(), $file))
        {
            throw new AccessDeniedHttpException("Vous n'avez pas l'autorisation d'accéder à ce fichier.");
        }

        return new BinaryFileResponse('uploads/'.$file->getPath());
    }

    /**
     * @Route("/dashboard/file/edit_order", name="file_edit_order")
     */
    public function fileEditOrderAction(Request $request)
    {

        if($request->isXmlHttpRequest()) {
            $content = $request->getContent();
            $em = $this->getDoctrine()->getManager();
            $response = new Response();

            if(!empty($content))
            {

                $param = json_decode($request->getContent(), true);

                foreach($param['items'] as $item)
                {
                    $menu_item = $this->getDoctrine()->getRepository(FileUpload::class)->findOneBy([
                        'id' => $item['id']
                    ]);
                    $menu_item->setOrder($item['order']);
                    $em->persist($menu_item);
                    $em->flush();
                    $data = json_encode('ok');
                }
            }
            else
            {
                $data = json_encode('ko');
            }
            $response->headers->set('Content-Type', 'application/json');
            $response->setContent($data);

            return $response;
        }
        return null;
    }

    /**
     * @Route("/file/public/view/{file_id}", name="file_public_view")
     */
    public function filePublicViewAction($file_id)
    {

        $file = $this->getDoctrine()->getRepository(FileUpload::class)->findOneBy([
            'id' => $file_id
        ]);

        return new BinaryFileResponse('uploads/'.$file->getPath());
    }

}