<?php

namespace FrontBundle\Controller;

use AppBundle\Entity\AccessibilityRegister;
use AppBundle\Entity\Erp;
use AppBundle\Service\AccessManager;
use FrontBundle\Form\ErpType;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpKernel\Exception\AccessDeniedHttpException;

class ErpController extends Controller
{
    /**
     * @Route("/dashboard/erp/create", name="erp_create")
     */
    public function erpCreateAction(Request $request)
    {
        $user = $this->getUser();

        $erp = new Erp();
        $form = $this->createForm(ErpType::class, $erp);

        $form->handleRequest($request);
        if ($form->isSubmitted() && $form->isValid()) {
            $erp->setCompany($user->getCompany());

            $em = $this->getDoctrine()->getManager();
            $em->persist($erp);
            $em->flush();

            $this->addFlash('notice', 'L\'établissement a bien été créé, vous pouvez maintenant y associer son registre d\'accessibilité.');

            return $this->redirectToRoute('register_create', [
                'erp_id' => $erp->getId()
            ]);
        }


        return $this->render('Front/Dashboard/erp/create.html.twig', [
            'form' => $form->createView(),
            'company' => $user->getCompany()
        ]);
    }

    /**
     * @Route("/dashboard/erp/edit/{erp_id}", name="erp_edit")
     */
    public function erpEditAction(Request $request, $erp_id, AccessManager $accessManager)
    {

        $erp = $this->getDoctrine()->getRepository(Erp::class)->findOneBy([
            'id' => $erp_id
        ]);

        if(!$accessManager->checkUserbyErp($this->getUser(), $erp))
        {
            throw new AccessDeniedHttpException("Vous n'avez pas l'autorisation d'éditer cet ERP.");
        }

        $form = $this->createForm(ErpType::class, $erp);

        $form->handleRequest($request);
        if ($form->isSubmitted() && $form->isValid()) {

            $em = $this->getDoctrine()->getManager();
            $em->persist($erp);
            $em->flush();

            $this->addFlash('notice', 'L\'établissement a bien été modifié');

            return $this->redirectToRoute('dashboard_index');

        }

        return $this->render('Front/Dashboard/erp/edit.html.twig', [
            'form' => $form->createView(),
            'company' => $this->getUser()->getCompany()
        ]);
    }

    /**
     * @Route("/dashboard/erp/show/{erp_id}", name="erp_show")
     */
    public function erpShowAction(Request $request, $erp_id, AccessManager $accessManager)
    {

        $erp = $this->getDoctrine()->getRepository(Erp::class)->findOneBy([
            'id' => $erp_id
        ]);

        if(!$accessManager->checkUserbyErp($this->getUser(), $erp))
        {
            throw new AccessDeniedHttpException("Vous n'avez pas l'autorisation de consulter cet établissement.");
        }

        # Get last QR Code
        $last_qr_code = $this->getDoctrine()->getRepository(AccessibilityRegister::class)->findOneByLastGeneratedQrCodeRegister($erp);

        # Get All registers of ERP by date DESC
        $registers = $this->getDoctrine()->getRepository(AccessibilityRegister::class)->findBy(['erp' => $erp],[
            'validated_at' => 'DESC'
        ]);

        # Get public register version
        $public_register = $this->getDoctrine()->getRepository(AccessibilityRegister::class)->findOnePublicVersionRegister($erp);

        return $this->render('Front/Dashboard/erp/show.html.twig', [
            'erp' => $erp,
            'last_qr_code' => $last_qr_code,
            'registers' => $registers,
            'public_register' => $public_register
        ]);
    }


}
