<?php

namespace FrontBundle\Controller;

use AppBundle\Entity\AccessibilityRegister;
use AppBundle\Entity\BonusParrainage;
use AppBundle\Entity\Erp;
use AppBundle\Entity\Exchange;
use AppBundle\Entity\Invoice;
use AppBundle\Entity\NavigationMenu;
use AppBundle\Entity\Order;
use AppBundle\Entity\Post;
use AppBundle\Entity\PrintRequest;
use AppBundle\Entity\RefPrintStatus;
use AppBundle\Entity\SiteAccessibleSearchHistory;
use AppBundle\Service\AccessManager;
use AppBundle\Service\MailManager;
use AppBundle\Service\QrCodeGenerator;
use Endroid\QrCode\QrCode;
use FrontBundle\Form\ContactType;
use FrontBundle\Form\ParrainageSendType;
use Spipu\Html2Pdf\Html2Pdf;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpKernel\Exception\AccessDeniedHttpException;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;

class DefaultController extends Controller
{

    /**
     * @Route("/", name="siteAccessible_index", host="%site_accessible_domain%")
     */
    public function siteAccessibleIndexAction(Request $request)
    {
        $erps = null;
        if($request->isMethod('GET'))
        {

            $ip = $request->getClientIp();
            if($ip == 'unknown'){
                $ip = $_SERVER['REMOTE_ADDR'];
            }

            $em = $this->getDoctrine()->getManager();

            $searchHistory = new SiteAccessibleSearchHistory();
            $searchHistory->setUserIp($ip);

            if($request->get('siret'))
            {
                $siret = $request->get('siret');
                $erps = $this->getDoctrine()->getRepository(Erp::class)->findBySiret($siret);

                $searchHistory->setSiret($siret)
                    ->setResults(count($erps));
                $em->persist($searchHistory);
                $em->flush();
            }

            if($request->get('name') && $request->get('post_code'))
            {
                $name = $request->get('name');
                $post_code = $request->get('post_code');
                $erps = $this->getDoctrine()->getRepository(Erp::class)->findByNameAndPostCode($name, $post_code);

                $searchHistory->setErpName($name)
                ->setPostalCode($post_code)
                ->setResults(count($erps));
                $em->persist($searchHistory);
                $em->flush();
            }

        }
        return $this->render('Front/SiteAccessible/index.html.twig', [
            'erps' => $erps
        ]);
    }

    /**
     * @Route("/", name="homepage", host="%domain%")
     */
    public function indexAction(Request $request)
    {
        return $this->render('Front/index.html.twig');
    }

    /**
     * @Route("/page/{slug}", name="front_post", host="%domain%")
     */
    public function frontPostAction($slug)
    {
        $post = $this->getDoctrine()->getRepository(Post::class)
            ->findOneBy([
                'slug' => $slug
            ]);

        return $this->render('Front/post.html.twig', [
            'post' => $post
        ]);
    }

    /**
     * @Route("/contact", name="front_contact", host="%domain%")
     */
    public function frontContactAction(Request $request, MailManager $mailManager)
    {
        $form = $this->createForm(ContactType::class, null, [
            'action' => $this->generateUrl('front_contact'),
            'method' => 'POST'
        ]);

        $form->handleRequest($request);
        if ($form->isSubmitted() && $form->isValid()) {

            $mailManager->sendContactEmail($form->getData());

            $this->addFlash('notice', 'Votre message a bien été envoyé.');
            return $this->redirectToRoute('front_contact');
        }

        return $this->render('Front/contact.html.twig', [
            'contactForm' => $form->createView()
        ]);
    }

    /**
     * @Route("/front/menu", name="front_menu")
     */
    public function frontMenuAction($route, $params)
    {

        $nav = $this->getDoctrine()->getRepository(NavigationMenu::class)->findBy([],[
            'order' => 'ASC'
        ]);


        return $this->render('Front/_nav.html.twig', [
            'nav' => $nav,
            'route' => $route,
            'params' => $params,
        ]);
    }

    /**
     * @Route("/dashboard", name="dashboard_index", host="%domain%")
     */
    public function dashboardIndexAction(Request $request)
    {

        $user = $this->getUser();


        if($user->getRole() == 'ROLE_ADMIN')
        {
            return $this->redirectToRoute('admin_index');
        }

        $company = $user->getCompany();

        $erp = $this->getDoctrine()->getRepository(Erp::class)
            ->findBy([
                'company' => $company,
            ]);

        return $this->render('Front/Dashboard/index.html.twig', [
            'erps' => $erp
        ]);
    }

    /**
     * @Route("/dashboard/invoice/list", name="invoice_list")
     */
    public function invoiceListAction(Request $request)
    {
        $company= $this->getUser()->getCompany();

        $invoices = $this->getDoctrine()->getRepository(Invoice::class)->findBy(
            ['company' => $company ], ['created_at' => 'DESC']);

        return $this->render('Front/Dashboard/invoice/list.html.twig', [
            'invoices' => $invoices
        ]);
    }

    /**
     * @Route("/dashboard/confirm/reception/{print_request_id}", name="confirm_reception_register", host="%domain%")
     */
    public function confirmReceptionRegisterAction(Request $request, $print_request_id, AccessManager $accessManager)
    {
        $print_request = $this->getDoctrine()->getRepository(PrintRequest::class)->findOneBy([
            'id' => $print_request_id
        ]);

        if(!$accessManager->checkUserbyPrintRequest($this->getUser(), $print_request))
        {
            throw new AccessDeniedHttpException('Vous ne pouvez pas faire cette action.');
        }

        $status = $this->getDoctrine()->getRepository(RefPrintStatus::class)->findOneBy([
            'id' => 3
        ]);
        $print_request->setRefPrintStatus($status);

        $em = $this->getDoctrine()->getManager();
        $em->persist($print_request);
        $em->flush();

        return $this->redirectToRoute('order_summary', [
            'order_id' => $print_request->getOrder()->getId()
        ]);
    }

    /**
     * @Route("/test_emails/dza81zda68zd1a7dz687", name="test_emails")
     */
    public function testEmailsAction(Request $request, MailManager $mailManager)
    {

        $register = $this->getDoctrine()->getRepository(AccessibilityRegister::class)->findOneBy([
            'id' => 213
        ]);

        $exchange = $this->getDoctrine()->getRepository(Exchange::class)->findOneBy([
            'id' => 13
        ]);



        $mailManager->sendMydlCheckEmail($register, $exchange, $this->getUser());
        return new Response('ok');
    }

    /**
     * @Route("/test_qrcode/64d0a2489646841", name="test_qrcode")
     */
    public function testQrCodeAction(Request $request)
    {

        $erp = $this->getDoctrine()->getRepository(Erp::class)->findOneBy([
            'id' => 17
        ]);
        $register = $this->getDoctrine()->getRepository(AccessibilityRegister::class)->findOneBy([
            'erp' => $erp
        ]);

        $qrCodePath = 'qrcode-115.png';

        require_once(__DIR__.'/../../../vendor/autoload.php');
        $html2pdf = new Html2Pdf();

        $html2pdf->writeHTML($this->renderView('Pdf/qr_code.html.twig', [
            'register' => $register,
            'qrcodepath' => $qrCodePath
        ]));

        $fichier = $html2pdf->output('toto.pdf');
        $response = new Response();
        $response->setContent(file_get_contents($fichier));
        $response->headers->set('Content-Type', 'application/force-download');
        $response->headers->set('Content-disposition', 'filename='. $fichier);

        return $response;

    }

}
