<?php

namespace FrontBundle\Controller;

use AppBundle\Entity\Company;
use AppBundle\Service\AccessManager;
use FrontBundle\Form\CompanyType;
use FrontBundle\Form\ErpType;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpKernel\Exception\AccessDeniedHttpException;

class CompanyController extends Controller
{

    /**
     * @Route("/dashboard/company/edit/{company_id}", name="company_edit")
     */
    public function companyEditAction(Request $request, $company_id, AccessManager $accessManager)
    {

        $company = $this->getDoctrine()->getRepository(Company::class)->findOneBy([
            'id' => $company_id
        ]);

        if(!$accessManager->checkUserbyCompany($this->getUser(), $company))
        {
            throw new AccessDeniedHttpException("Vous n'avez pas l'autorisation d'éditer cette société.");
        }

        $form = $this->createForm(CompanyType::class, $company);

        $form->handleRequest($request);
        if ($form->isSubmitted() && $form->isValid()) {

            $em = $this->getDoctrine()->getManager();
            $em->persist($company);
            $em->flush();

            $this->addFlash('notice', 'La société a bien été modifiée');

            return $this->redirectToRoute('dashboard_index');

        }

        return $this->render('Front/Dashboard/company/edit.html.twig', [
            'form' => $form->createView()
        ]);
    }


}
