<?php

namespace AppBundle\Validator\Constraints;

use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\ConstraintValidator;

class LuhnValidator extends ConstraintValidator
{

    public function validate($value, Constraint $constraint)
    {

        $initial_value = $value;
        function is_valid_luhn($number) {
            settype($number, 'string');
            $sumTable = array(
                array(0,1,2,3,4,5,6,7,8,9),
                array(0,2,4,6,8,1,3,5,7,9));
            $sum = 0;
            $flip = 0;
            for ($i = strlen($number) - 1; $i >= 0; $i--) {
                $sum += $sumTable[$flip++ & 0x1][$number[$i]];
            }
            return $sum % 10 === 0;
        }

        if (!is_valid_luhn($value) || $value == "000000000" || $value == "00000000000000") {
            $message = "Numéro incorrect";
            if(strlen($initial_value) == 9) {
                $message = "Le N° SIREN est incorrect.";
            } elseif(strlen($initial_value) == 14) {
                $message = "Le N° SIRET est incorrect.";
            }
            $this->context->buildViolation($message)
                ->addViolation();
        }
    }

}