<?php

namespace AppBundle\Twig;

class AppExtension extends \Twig_Extension
{
    public function getFilters()
    {
        return array(
            new \Twig_SimpleFilter('ordersort', array($this, 'orderSortFilter')),
        );
    }

    public function orderSortFilter($files)
    {
        uasort($files, function($a, $b) {
            return strcmp($a->getOrder(), $b->getOrder());
        } );
        return $files;
    }

    public function priceFilter($number, $decimals = 0, $decPoint = '.', $thousandsSep = ',')
    {
        $price = number_format($number, $decimals, $decPoint, $thousandsSep);
        $price = '$'.$price;

        return $price;
    }
}