<?php

namespace AppBundle\Service;


use Doctrine\ORM\EntityManager;
use Endroid\QrCode\QrCode;
use Spipu\Html2Pdf\Html2Pdf;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\Routing\RouterInterface;

class QrCodeGenerator
{

    protected $entityManager;
    protected $files_directory;
    protected $qrcodes_directory;
    protected $router;
    protected $templating;

    public function __construct(EntityManager $entityManager, $files_directory, $qrcodes_directory, $router, $templating)
    {
        $this->em = $entityManager;
        $this->files_directory = $files_directory;
        $this->qrcodes_directory = $qrcodes_directory;
        $this->router = $router;
        $this->templating = $templating;
    }

    public function generate($registers)
    {
        foreach($registers as $register)
        {
            $url_for_qr_code = $this->router->generate('siteAccessible_view', ['erp_slug' => $register->getErp()->getSlug()], UrlGeneratorInterface::ABSOLUTE_URL);
            $qrCode = new QrCode($url_for_qr_code);
            $qrCode->writeFile($this->qrcodes_directory.'qrcode-'.$register->getId().'.png');

            $qrCodePath = 'qrcode-'.$register->getId().'.png';

            require_once(__DIR__.'/../../../vendor/autoload.php');
            $html2pdf = new Html2Pdf();
            $html2pdf->writeHTML($this->templating->render('Pdf/qr_code.html.twig', [
                'register' => $register,
                'qrcodepath' => $qrCodePath
            ]));

            $pdfname = 'qrcode-pdf'.$register->getId().'.pdf';
            $html2pdf->output($this->files_directory.'qrcodes-pdf/'.$pdfname, 'F');
            $register->setQrCode($pdfname);

            $this->em->persist($register);
            $this->em->flush();
        }
    }

    public function generateSingle($register)
    {
        $url_for_qr_code = $this->router->generate('siteAccessible_view', ['erp_slug' => $register->getErp()->getSlug()], UrlGeneratorInterface::ABSOLUTE_URL);
        $qrCode = new QrCode($url_for_qr_code);
        $qrCode->writeFile($this->qrcodes_directory.'qrcode-'.$register->getId().'.png');

        $qrCodePath = 'qrcode-'.$register->getId().'.png';

        require_once(__DIR__.'/../../../vendor/autoload.php');
        $html2pdf = new Html2Pdf();
        $html2pdf->writeHTML($this->templating->render('Pdf/qr_code.html.twig', [
            'register' => $register,
            'qrcodepath' => $qrCodePath
        ]));

        $pdfname = 'qrcode-pdf'.$register->getId().'.pdf';
        $html2pdf->output($this->files_directory.'qrcodes-pdf/'.$pdfname, 'F');
        $register->setQrCode($pdfname);

        $this->em->persist($register);
        $this->em->flush();
    }

}