<?php

namespace AppBundle\Service;


use Doctrine\ORM\EntityManager;

class PdfGenerator
{

    protected $entityManager;
    protected $files_directory;

    public function __construct(EntityManager $entityManager, $files_directory)
    {
        $this->em = $entityManager;
        $this->files_directory = $files_directory;
    }

    public function generate($registers)
    {

        function slugify($text)
        {
            // replace non letter or digits by -
            $text = preg_replace('~[^\\pL\d]+~u', '-', $text);
            // trim
            $text = trim($text, '-');
            // transliterate
            if (function_exists('iconv'))
            {
                $text = iconv('utf-8', 'us-ascii//TRANSLIT', $text);
            }
            // lowercase
            $text = strtolower($text);
            // remove unwanted characters
            $text = preg_replace('~[^-\w]+~', '', $text);
            if (empty($text))
            {
                return 'n-a';
            }
            return $text;
        }


        foreach($registers as $register)
        {
            $allPdfQuery = $register->getOrderedFileUploads();

            $pdfArray = [];
            $datadir = $this->files_directory;
            #$name = md5(uniqid()).'.pdf';
            $erp_slug = slugify($register->getErp()->getName());
            $name = 'registre_'.$register->getId().'_'.$erp_slug.'_'.date('Y-m-d').'.pdf';
            $outputName = $datadir.$name;


            $pdfArray[0][] = $datadir.'default-pdf/0-0couverture.pdf';
            $pdfArray[0][] = $datadir.'default-pdf/0-1-intercalaire.pdf';
            foreach($allPdfQuery as $pdf)
            {

                $type = $pdf->getFileType()->getId();

                if(!array_key_exists($type, $pdfArray))
                {
                    $pdfArray[$type] = [];
                    $pdfArray[$type][] = $datadir.'default-pdf/type-'.$type.'.pdf';
                }

                $pdfArray[$type][] = $datadir.$pdf->getPath();
            }


            $pdfArray[][] = $datadir.'default-pdf/0-2-intercalaire.pdf';

            $cmd = "gs -q -dNOPAUSE -dBATCH -sDEVICE=pdfwrite -sOutputFile=$outputName ";
            foreach($pdfArray as $pdfs)
            {
                foreach($pdfs as $pdf)
                {
                    $cmd .= $pdf." ";
                }
            }
            shell_exec($cmd);
            $register->setPdf($name);
            $now = new \DateTime();
            $register->setGeneratedAt($now);
            $register->setUpdatedAt($now);
            $this->em->persist($register);
            $this->em->flush();
        }
    }

    public function generateOnePdf($register)
    {

        function slugify($text)
        {
            // replace non letter or digits by -
            $text = preg_replace('~[^\\pL\d]+~u', '-', $text);
            // trim
            $text = trim($text, '-');
            // transliterate
            if (function_exists('iconv'))
            {
                $text = iconv('utf-8', 'us-ascii//TRANSLIT', $text);
            }
            // lowercase
            $text = strtolower($text);
            // remove unwanted characters
            $text = preg_replace('~[^-\w]+~', '', $text);
            if (empty($text))
            {
                return 'n-a';
            }
            return $text;
        }


        $allPdfQuery = $register->getOrderedFileUploads();

        $pdfArray = [];
        $datadir = $this->files_directory;
        #$name = md5(uniqid()).'.pdf';
        $erp_slug = slugify($register->getErp()->getName());
        $name = 'registre_'.$register->getId().'_'.$erp_slug.'_'.date('Y-m-d').'.pdf';
        $outputName = $datadir.$name;


        $pdfArray[0][] = $datadir.'default-pdf/0-0couverture.pdf';
        $pdfArray[0][] = $datadir.'default-pdf/0-1-intercalaire.pdf';
        foreach($allPdfQuery as $pdf)
        {

            $type = $pdf->getFileType()->getId();

            if(!array_key_exists($type, $pdfArray))
            {
                $pdfArray[$type] = [];
                $pdfArray[$type][] = $datadir.'default-pdf/type-'.$type.'.pdf';
            }

            $pdfArray[$type][] = $datadir.$pdf->getPath();
        }


        $pdfArray[][] = $datadir.'default-pdf/0-2-intercalaire.pdf';

        $cmd = "gs -q -dNOPAUSE -dBATCH -sDEVICE=pdfwrite -sOutputFile=$outputName ";
        foreach($pdfArray as $pdfs)
        {
            foreach($pdfs as $pdf)
            {
                $cmd .= $pdf." ";
            }
        }
        shell_exec($cmd);
        $register->setPdf($name);
        $now = new \DateTime();
        $register->setGeneratedAt($now);
        $register->setUpdatedAt($now);
        $this->em->persist($register);
        $this->em->flush();
    }

}