<?php

namespace AppBundle\Service;

use AppBundle\Entity\AccessibilityRegister;
use AppBundle\Entity\Company;
use AppBundle\Entity\Erp;
use AppBundle\Entity\FileUpload;
use AppBundle\Entity\Order;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\Routing\RouterInterface;

class OrderRedirectManager
{


    public function __construct()
    {

    }

    public function redirectByStatus(Order $order)
    {

        $status = $order->getStatus()->getId();

        if($status == 1)
        {
            return $this->redirectToRoute('order_choose', ['order_id' => $order->getId()]);
        }
        elseif($status == 2)
        {
            return $this->redirectToRoute('order_pay', ['order_id' => $order->getId()]);
        }
        elseif(in_array($status, [3,4,5,6,7,8]))
        {
            return $this->redirectToRoute('order_summary', ['order_id' => $order->getId()]);
        }
        else
        {
            return $this->redirectToRoute('dashboard_index');
        }


        return false;
    }

}