<?php

namespace AppBundle\Service;

use AppBundle\Entity\Order;
use AppBundle\Entity\RefOrderStatus;
use AppBundle\Entity\User;
use AppBundle\Entity\OrderHistory;
use Doctrine\ORM\EntityManager;
use AppBundle\Repository\OrderHistoryRepository;

class OrderHistoryManager
{

    protected $entityManager;
    protected $orderRepository;

    public function __construct(EntityManager $entityManager)
    {
        $this->em = $entityManager;
    }

    public function setHistory(Order $order, $old_status_id, $new_status_id, User $user)
    {

        $old_status = $this->em->getRepository(RefOrderStatus::class)->findOneBy([
            'id' => $old_status_id
        ]);
        $new_status = $this->em->getRepository(RefOrderStatus::class)->findOneBy([
            'id' => $new_status_id
        ]);


        $orderHistory = new OrderHistory();

        $orderHistory
            ->setOrder($order)
            ->setOldStatus($old_status)
            ->setNewStatus($new_status)
            ->setUser($user)
        ;

        $this->em->persist($orderHistory);
        $this->em->flush();

    }



}