<?php

namespace AppBundle\Service;


use AppBundle\Entity\Invoice;
use AppBundle\Entity\Order;
use Doctrine\ORM\EntityManager;
use Spipu\Html2Pdf\Html2Pdf;

class InvoiceGenerator
{

    protected $entityManager;
    protected $invoices_directory;
    protected $templating;

    public function __construct(EntityManager $entityManager, $invoices_directory, $templating)
    {
        $this->em = $entityManager;
        $this->invoices_directory = $invoices_directory;
        $this->templating = $templating;
    }

    public function generate(Order $order)
    {
        $pdfname = 'invoice-pdf'.$order->getId().'.pdf';
        $invoice = new Invoice();

        $invoice->setOrder($order);
        $invoice->setCompany($order->getCompany());
        $invoice->setPdf($pdfname);

        $this->em->persist($invoice);
        $this->em->flush();

        $invoice->setInvoiceNumber('RA_'.$invoice->getId());

        $this->em->persist($invoice);
        $this->em->flush();

        require_once(__DIR__.'/../../../vendor/autoload.php');
        $html2pdf = new Html2Pdf();
        $html2pdf->writeHTML($this->templating->render('Pdf/invoice.html.twig', [
            'order' => $order,
            'invoice' => $invoice
        ]));


        $html2pdf->output($this->invoices_directory.$pdfname, 'F');

    }

}