<?php

namespace AppBundle\Service;

use AppBundle\Entity\AccessibilityRegister;
use AppBundle\Entity\Company;
use AppBundle\Entity\Erp;
use AppBundle\Entity\FileUpload;
use AppBundle\Entity\Order;
use AppBundle\Entity\PrintRequest;
use AppBundle\Entity\User;

class AccessManager
{


    public function __construct()
    {

    }

    public function checkUserbyRegister(User $user, AccessibilityRegister $register)
    {

        if($user->getCompany() == $register->getErp()->getCompany())
        {
            return true;
        }

        if($user->getRole() == "ROLE_ADMIN")
        {
            return true;
        }

        return false;
    }

    public function checkUserbyCompany(User $user, Company $company)
    {

        if($user->getCompany() == $company)
        {
            return true;
        }

        if($user->getRole() == "ROLE_ADMIN")
        {
            return true;
        }

        return false;
    }

    public function checkUserbyErp(User $user, Erp $erp)
    {

        if($user->getCompany() == $erp->getCompany())
        {
            return true;
        }

        return false;
    }

    public function checkUserbyFileUpload(User $user, FileUpload $fileUpload)
    {

        if($user->getCompany() == $fileUpload->getErp()->getCompany())
        {
            return true;
        }

        if($user->getRole() == "ROLE_ADMIN")
        {
            return true;
        }

        return false;
    }

    public function checkUserbyOrder(User $user, Order $order)
    {

        if($user->getCompany() == $order->getCompany())
        {
            return true;
        }

        return false;
    }

    public function checkUserbyPrintRequest(User $user, PrintRequest $printRequest)
    {

        if($user->getCompany() == $printRequest->getOrder()->getCompany())
        {
            return true;
        }

        return false;
    }

}