<?php

namespace AppBundle\Repository;

use Doctrine\ORM\EntityRepository;

class QrCodeRequestRepository extends EntityRepository
{
    public function findByEligibleQrCode()
    {
        $qb = $this->createQueryBuilder('q')
            ->where('q.status = pending')
        ;
        return $qb->getQuery()->getResult();
    }

    public function findByStatusNew()
    {
        $qb = $this->createQueryBuilder('q')
            ->leftJoin('q.register', 'r')
            ->leftJoin('r.erp', 'e')
            ->where('r.validated_at IS NOT NULL')
            ->andWhere('r.validation_status IS NULL OR r.validation_status = :status')
            ->setParameter('status', 'ok')
            ->andWhere('q.status = :status')
            ->setParameter('status', 'pending')
        ;
        return $qb->getQuery()->getResult();
    }


    public function findByStatusDone()
    {
        $qb = $this->createQueryBuilder('q')
            ->leftJoin('q.register', 'r')
            ->leftJoin('r.erp', 'e')
            ->where('r.validated_at IS NOT NULL')
            ->andWhere('r.validation_status IS NULL OR r.validation_status = :status')
            ->setParameter('status', 'ok')
            ->andWhere('q.status = :status')
            ->setParameter('status', 'send')
        ;
        return $qb->getQuery()->getResult();
    }
}