<?php

namespace AppBundle\Repository;

use Doctrine\ORM\EntityRepository;

class QrCodeRepository extends EntityRepository
{

    public function findByAvailableQrCode()
    {
        $qb = $this->createQueryBuilder('q')
            ->where('q.assigned_at IS NULL')
            ->orderBy('q.hash', 'ASC')
            ->setMaxResults(1)
        ;
        return $qb->getQuery()->getOneOrNullResult();
    }


    public function findByHashRange($min, $max)
    {
        $qb = $this->createQueryBuilder('q')
            ->where('q.hash >= :min')
            ->andWhere('q.hash <= :max')
            ->setParameter('min', $min)
            ->setParameter('max', $max)
            ->orderBy('q.hash', 'ASC')
        ;
        return $qb->getQuery()->getResult();
    }

}