<?php

namespace AppBundle\Repository;

use Doctrine\ORM\EntityRepository;

class PrintRequestRepository extends EntityRepository
{
    public function findByEligibleRegister()
    {
        $qb = $this->createQueryBuilder('p')
            ->leftJoin('p.register', 'r')
            ->where('r.validated_at IS NOT NULL')
            ->andWhere('r.validation_status IS NULL OR r.validation_status = :status')
            ->setParameter('status', 'ok')
        ;
        return $qb->getQuery()->getResult();
    }

    public function findByStatusNew()
    {
        $qb = $this->createQueryBuilder('p')
            ->leftJoin('p.register', 'r')
            ->leftJoin('r.erp', 'e')
            ->where('r.validated_at IS NOT NULL')
            ->andWhere('r.validation_status IS NULL OR r.validation_status = :status')
            ->setParameter('status', 'ok')
            ->andWhere('p.refPrintStatus = :print_status')
            ->setParameter('print_status', '1')
        ;
        return $qb->getQuery()->getResult();
    }

    public function findByStatusDone()
    {
        $qb = $this->createQueryBuilder('p')
            ->leftJoin('p.register', 'r')
            ->leftJoin('r.erp', 'e')
            ->where('r.validated_at IS NOT NULL')
            ->andWhere('r.validation_status IS NULL OR r.validation_status = :status')
            ->setParameter('status', 'ok')
            ->andWhere('p.refPrintStatus IN (:print_status)')
            ->setParameter('print_status', [2,3])
        ;
        return $qb->getQuery()->getResult();
    }
}