<?php

namespace AppBundle\Repository;

use Doctrine\ORM\EntityRepository;

class ErpRepository extends EntityRepository
{
    public function findBySiret($siret)
    {
        $qb = $this->createQueryBuilder('e')
            ->leftJoin('e.accessibilityRegisters', 'p')
            ->leftJoin('p.order', 'o')
            ->where('e.siret = (:siret)')
            ->setParameter('siret', $siret)
            ->setMaxResults(10)

        ;
        return $qb->getQuery()->getResult();
    }

    public function findByNameAndPostCode($name, $postal_code)
    {
        $qb = $this->createQueryBuilder('e')
            ->leftJoin('e.accessibilityRegisters', 'p')
            ->where('e.name LIKE :name')
            ->setParameter('name', $name)
            ->andWhere('e.postalCode = (:postal_code)')
            ->setParameter('postal_code', $postal_code)
            ->setMaxResults(10)

        ;
        return $qb->getQuery()->getResult();
    }
}