<?php

namespace AppBundle\Repository;

use Doctrine\ORM\EntityRepository;

class AccessibilityRegisterRepository extends EntityRepository
{
    public function findOneByLastOrderedRegister($erp)
    {
        $qb = $this->createQueryBuilder('r')
            ->leftJoin('r.order', 'o')
            ->leftJoin('o.status', 's')
            ->where('r.erp = (:erp)' )
            ->setParameter('erp', $erp)
            ->andWhere('s.id = 3')
            ->orderBy('r.generated_at', 'DESC')
            ->setMaxResults(1)
        ;

        return $qb->getQuery()->getOneOrNullResult();
    }

    public function findOneByLastGeneratedPdfRegister($erp)
    {
        $qb = $this->createQueryBuilder('r')
            ->where('r.erp = (:erp)')
            ->setParameter('erp', $erp)
            ->andWhere('r.pdf IS NOT NULL')
            ->orderBy('r.validated_at', 'DESC')
            ->setMaxResults(1)
            ;

        return $qb->getQuery()->getOneOrNullResult();
    }

    public function findOneByLastGeneratedQrCodeRegister($erp)
    {
        $qb = $this->createQueryBuilder('r')
            ->where('r.erp = (:erp)')
            ->setParameter('erp', $erp)
            ->andWhere('r.qrCode IS NOT NULL')
            ->orderBy('r.validated_at', 'DESC')
            ->setMaxResults(1)
            ;

        return $qb->getQuery()->getOneOrNullResult();
    }

    public function findOneByLastValidationRegister($erp)
    {
        $qb = $this->createQueryBuilder('r')
            ->where('r.erp = (:erp)')
            ->setParameter('erp', $erp)
            ->andWhere('r.validated_at IS NOT NULL')
            ->orderBy('r.validated_at', 'DESC')
            ->setMaxResults(1)
        ;

        return $qb->getQuery()->getOneOrNullResult();
    }

    public function findOnePublicVersionRegister($erp)
    {
        $qb = $this->createQueryBuilder('r')
            ->where('r.erp = (:erp)')
            ->setParameter('erp', $erp)
            ->andWhere('r.validated_at IS NOT NULL')
            ->orderBy('r.validated_at', 'DESC')
            ->andWhere('r.validation_status IS NULL OR r.validation_status = :status')
            ->setParameter('status', 'ok')
            ->setMaxResults(1)
        ;

        return $qb->getQuery()->getOneOrNullResult();
    }

    public function findOnePublicAndAuthorisedPdfVersionRegister($erp)
    {
        $qb = $this->createQueryBuilder('r')
            ->where('r.erp = (:erp)')
            ->setParameter('erp', $erp)
            ->andWhere('r.validated_at IS NOT NULL')
            ->orderBy('r.validated_at', 'DESC')
            ->andWhere('r.validation_status IS NULL OR r.validation_status = :status')
            ->setParameter('status', 'ok')
            ->andWhere('r.allow_pdf = 1')
            ->setMaxResults(1)
        ;

        return $qb->getQuery()->getOneOrNullResult();
    }

    public function findByValidationErpRegister($erp)
    {
        $qb = $this->createQueryBuilder('r')
            ->where('r.erp = (:erp)')
            ->setParameter('erp', $erp)
            ->andWhere('r.validation_status IS NOT NULL')
        ;
        return $qb->getQuery()->getResult();
    }
    public function findByValidationRegister()
    {
        $qb = $this->createQueryBuilder('r')
            ->where('r.validation_status IS NOT NULL')
        ;
        return $qb->getQuery()->getResult();
    }

}