<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity
 */
class Subscription
{

    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity="Erp", inversedBy="subscriptions", cascade={"persist"})
     */
    private $erp;

    /**
     * @ORM\ManyToOne(targetEntity="Order", inversedBy="subscriptions", cascade={"persist"})
     */
    private $order;

    /**
     * @ORM\Column(name="date_start", type="datetime", nullable=true)
     */
    private $date_start;

    /**
     * @ORM\Column(name="date_end", type="datetime", nullable=true)
     */
    private $date_end;

    /**
     * @ORM\ManyToOne(targetEntity="User", inversedBy="subscriptions", cascade={"persist"})
     * @ORM\JoinColumn(onDelete="SET NULL")
     */
    private $user;

    public function getId()
    {
        return $this->id;
    }

    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }

    public function getErp()
    {
        return $this->erp;
    }

    public function setErp($erp)
    {
        $this->erp = $erp;
        return $this;
    }

    public function getOrder()
    {
        return $this->order;
    }

    public function setOrder($order)
    {
        $this->order = $order;
        return $this;
    }

    public function getDateStart()
    {
        return $this->date_start;
    }

    public function setDateStart($date_start)
    {
        $this->date_start = $date_start;
        return $this;
    }

    public function getDateEnd()
    {
        return $this->date_end;
    }

    public function setDateEnd($date_end)
    {
        $this->date_end = $date_end;
        return $this;
    }

    public function getUser()
    {
        return $this->user;
    }

    public function setUser($user)
    {
        $this->user = $user;
        return $this;
    }

    public function isValid()
    {
        if($this->date_end > new \DateTime())
        {
            return true;
        }
        return false;
    }

}