<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity
 */
class SiteAccessibleSearchHistory
{

    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\Column(name="date", type="datetime", nullable=false)
     */
    private $date;

    /**
     * @ORM\Column(name="user_ip", type="string", length=255, nullable=true)
     */
    private $user_ip;

    /**
     * @ORM\Column(name="siret", type="string", length=255, nullable=true)
     */
    private $siret;

    /**
     * @ORM\Column(name="erp_name", type="string", length=255, nullable=true)
     */
    private $erp_name;

    /**
     * @ORM\Column(name="postal_code", type="string", length=255, nullable=true)
     */
    private $postal_code;

    /**
     * @ORM\Column(name="results", type="integer", nullable=true)
     */
    private $results;

    public function getId()
    {
        return $this->id;
    }

    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }

    public function getDate()
    {
        return $this->date;
    }

    public function setDate($date)
    {
        $this->date = $date;
        return $this;
    }

    public function getUserIp()
    {
        return $this->user_ip;
    }

    public function setUserIp($user_ip)
    {
        $this->user_ip = $user_ip;
        return $this;
    }

    public function getSiret()
    {
        return $this->siret;
    }

    public function setSiret($siret)
    {
        $this->siret = $siret;
        return $this;
    }

    public function getErpName()
    {
        return $this->erp_name;
    }

    public function setErpName($erp_name)
    {
        $this->erp_name = $erp_name;
        return $this;
    }

    public function getPostalCode()
    {
        return $this->postal_code;
    }

    public function setPostalCode($postal_code)
    {
        $this->postal_code = $postal_code;
        return $this;
    }

    public function getResults()
    {
        return $this->results;
    }

    public function setResults($results)
    {
        $this->results = $results;
        return $this;
    }

    public function __construct()
    {
        $this->date = new \DateTime();
    }

}