<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity
 */
class RefTypeFile
{

    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="label", type="string", length=255, nullable=false)
     */
    private $label;

    /**
     *
     * @ORM\Column(name="explanatory", type="text", nullable=false)
     */
    private $explanatory;

    /**
     * @ORM\OneToMany(targetEntity="FileUpload", mappedBy="fileType")
     */
    private $fileUploads;

    public function getId()
    {
        return $this->id;
    }

    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }

    public function getLabel()
    {
        return $this->label;
    }

    public function setLabel($label)
    {
        $this->label = $label;
        return $this;
    }

    public function getFileUploads()
    {
        return $this->fileUploads;
    }

    public function setFileUploads($fileUploads)
    {
        $this->fileUploads = $fileUploads;
        return $this;
    }

    public function getExplanatory()
    {
        return $this->explanatory;
    }

    public function setExplanatory($explanatory)
    {
        $this->explanatory = $explanatory;
        return $this;
    }


}