<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity
 */
class RefPrinter
{

    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="name", type="string", length=255, nullable=false)
     */
    private $name;

    /**
     * @var string
     *
     * @ORM\Column(name="email", type="string", length=255, nullable=false)
     */
    private $email;

    /**
     * @var string
     *
     * @ORM\Column(name="phone", type="string", length=255, nullable=false)
     */
    private $phone;

    /**
     * @var string
     *
     * @ORM\Column(name="address", type="string", length=255, nullable=false)
     */
    private $address;

    /**
     * @var string
     *
     * @ORM\Column(name="postal_code", type="string", length=255, nullable=false)
     */
    private $postal_code;

    /**
     * @var string
     *
     * @ORM\Column(name="city", type="string", length=255, nullable=false)
     */
    private $city;

    /**
     * @var string
     *
     * @ORM\Column(name="nb_files_transmitted", type="integer", nullable=true)
     */
    private $nb_files_transmitted;

    /**
     * @var string
     *
     * @ORM\Column(name="nb_files_inprogress", type="integer", nullable=true)
     */
    private $nb_files_inprogress;

    /**
     * @ORM\OneToMany(targetEntity="PrintRequest", mappedBy="printer")
     */
    private $printRequests;

    public function getId()
    {
        return $this->id;
    }

    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }

    public function getName()
    {
        return $this->name;
    }

    public function setName($name)
    {
        $this->name = $name;
        return $this;
    }

    public function getEmail()
    {
        return $this->email;
    }

    public function setEmail($email)
    {
        $this->email = $email;
        return $this;
    }

    public function getPhone()
    {
        return $this->phone;
    }

    public function setPhone($phone)
    {
        $this->phone = $phone;
        return $this;
    }

    public function getAddress()
    {
        return $this->address;
    }

    public function setAddress($address)
    {
        $this->address = $address;
        return $this;
    }

    public function getPostalCode()
    {
        return $this->postal_code;
    }

    public function setPostalCode($postal_code)
    {
        $this->postal_code = $postal_code;
        return $this;
    }

    public function getCity()
    {
        return $this->city;
    }

    public function setCity($city)
    {
        $this->city = $city;
        return $this;
    }

    public function getNbFilesTransmitted()
    {
        return $this->nb_files_transmitted;
    }

    public function setNbFilesTransmitted($nb_files_transmitted)
    {
        $this->nb_files_transmitted = $nb_files_transmitted;
        return $this;
    }

    public function getNbFilesInprogress()
    {
        return $this->nb_files_inprogress;
    }

    public function setNbFilesInprogress($nb_files_inprogress)
    {
        $this->nb_files_inprogress = $nb_files_inprogress;
        return $this;
    }

    public function getPrintRequests()
    {
        return $this->printRequests;
    }

    public function setPrintRequests($printRequests)
    {
        $this->printRequests = $printRequests;
        return $this;
    }

}