<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Doctrine\ORM\Mapping\QuoteStrategy;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * @ORM\Entity
 */
class RefPrintStatus
{

    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="label", type="string", length=255, nullable=false)
     */
    private $label;

    /**
     * @ORM\OneToMany(targetEntity="PrintRequest", mappedBy="refPrintStatus")
     */
    private $printRequests;

    public function getId()
    {
        return $this->id;
    }

    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }

    public function getLabel()
    {
        return $this->label;
    }

    public function setLabel($label)
    {
        $this->label = $label;
        return $this;
    }

    public function getPrintRequests()
    {
        return $this->printRequests;
    }

    public function setPrintRequests($printRequests)
    {
        $this->printRequests = $printRequests;
        return $this;
    }

}