<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Doctrine\ORM\Mapping\QuoteStrategy;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * @ORM\Entity
 */
class RefOrderStatus
{

    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="label", type="string", length=255, nullable=false)
     */
    private $label;

    /**
     * @var string
     *
     * @ORM\Column(name="order", type="string", length=255, nullable=false)
     */
    private $order;

    /**
     * @var string
     *
     * @ORM\Column(name="color", type="string", length=255, nullable=true)
     */
    private $color;

    /**
     * @ORM\OneToMany(targetEntity="Order", mappedBy="status")
     */
    private $orders;

    /**
     * @ORM\OneToMany(targetEntity="OrderHistory", mappedBy="old_status")
     */
    private $orderHistorysOld;

    /**
     * @ORM\OneToMany(targetEntity="OrderHistory", mappedBy="new_status")
     */
    private $orderHistorysNew;

    public function getId()
    {
        return $this->id;
    }

    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }

    public function getLabel()
    {
        return $this->label;
    }

    public function setLabel($label)
    {
        $this->label = $label;
        return $this;
    }

    public function getOrder()
    {
        return $this->order;
    }

    public function setOrder($order)
    {
        $this->order = $order;
        return $this;
    }

    public function getOrders()
    {
        return $this->orders;
    }

    public function setOrders($orders)
    {
        $this->orders = $orders;
        return $this;
    }

    public function getOrderHistorysOld()
    {
        return $this->orderHistorysOld;
    }

    public function setOrderHistorysOld($orderHistorysOld)
    {
        $this->orderHistorysOld = $orderHistorysOld;
        return $this;
    }

    public function getOrderHistorysNew()
    {
        return $this->orderHistorysNew;
    }

    public function setOrderHistorysNew($orderHistorysNew)
    {
        $this->orderHistorysNew = $orderHistorysNew;
        return $this;
    }

    public function getColor()
    {
        return $this->color;
    }

    public function setColor($color)
    {
        $this->color = $color;
        return $this;
    }

}