<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity
 */
class RefCategoryErp
{

    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="label", type="string", length=255, nullable=false)
     */
    private $label;

    /**
     * @ORM\OneToMany(targetEntity="Erp", mappedBy="categoryErp")
     */
    private $erps;

    /**
     * @ORM\ManyToMany(targetEntity="RefTypeFile", cascade={"persist"})
     */
    private $typesFile;

    public function getId()
    {
        return $this->id;
    }

    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }

    public function getLabel()
    {
        return $this->label;
    }

    public function setLabel($label)
    {
        $this->label = $label;
        return $this;
    }

    public function getErps()
    {
        return $this->erps;
    }

    public function setErps($erps)
    {
        $this->erps = $erps;
        return $this;
    }

    public function getTypesFile()
    {
        return $this->typesFile;
    }

    public function setTypesFile($typesFile)
    {
        $this->typesFile = $typesFile;
        return $this;
    }

}