<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass="AppBundle\Repository\QrCodeRepository")
 */
class QrCode
{

    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\Column(name="assigned_at", type="datetime", nullable=true)
     */
    private $assigned_at;

    /**
     * @var string
     *
     * @ORM\Column(name="hash", type="string", length=255, nullable=false, unique=true)
     */
    private $hash;

    /**
     * @var string
     *
     * @ORM\Column(name="pdf", type="string", length=255, nullable=true)
     */
    private $pdf;

    /**
     * @ORM\OneToOne(targetEntity="AccessibilityRegister", mappedBy="qrCode")
     */
    private $register;

    public function getId()
    {
        return $this->id;
    }

    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }

    public function getAssignedAt()
    {
        return $this->assigned_at;
    }

    public function setAssignedAt($assigned_at)
    {
        $this->assigned_at = $assigned_at;
        return $this;
    }

    public function getHash()
    {
        return $this->hash;
    }

    public function setHash($hash)
    {
        $this->hash = $hash;
        return $this;
    }

    public function getPdf()
    {
        return $this->pdf;
    }

    public function setPdf($pdf)
    {
        $this->pdf = $pdf;
        return $this;
    }

    public function getRegister()
    {
        return $this->register;
    }

    public function setRegister($register)
    {
        $this->register = $register;
        return $this;
    }

    public function __construct()
    {
    }

}