<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity
 */
class Product
{

    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="reference", type="string", length=255, nullable=false)
     */
    private $reference;

    /**
     * @var string
     *
     * @ORM\Column(name="designation", type="string", length=255, nullable=false)
     */
    private $designation;

    /**
     *
     * @ORM\Column(name="price_ht", type="float", nullable=false)
     */
    private $price_ht;

    /**
     * @var string
     *
     * @ORM\Column(name="order", type="string", length=255, nullable=false)
     */
    private $order;

    /**
     * @ORM\ManyToOne(targetEntity="RefTva", inversedBy="products", cascade={"persist"})
     */
    private $tva;

    /**
     * @ORM\OneToMany(targetEntity="OrderDetails", mappedBy="product")
     */
    private $orderDetails;

    /**
     * @var string
     *
     * @ORM\Column(name="slug", type="string", length=255, nullable=false)
     */
    private $slug;

    public function getId()
    {
        return $this->id;
    }

    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }

    public function getReference()
    {
        return $this->reference;
    }

    public function setReference($reference)
    {
        $this->reference = $reference;
        return $this;
    }

    public function getDesignation()
    {
        return $this->designation;
    }

    public function setDesignation($designation)
    {
        $this->designation = $designation;
        return $this;
    }

    public function getPriceHt()
    {
        return $this->price_ht;
    }

    public function setPriceHt($price_ht)
    {
        $this->price_ht = $price_ht;
        return $this;
    }

    public function getOrder()
    {
        return $this->order;
    }

    public function setOrder($order)
    {
        $this->order = $order;
        return $this;
    }

    public function getTva()
    {
        return $this->tva;
    }

    public function setTva($tva)
    {
        $this->tva = $tva;
        return $this;
    }

    public function getOrderDetails()
    {
        return $this->orderDetails;
    }

    public function setOrderDetails($orderDetails)
    {
        $this->orderDetails = $orderDetails;
        return $this;
    }

    public function getSlug()
    {
        return $this->slug;
    }

    public function setSlug($slug)
    {
        $this->slug = $slug;
        return $this;
    }

}