<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass="AppBundle\Repository\OrderHistoryRepository")
 */
class OrderHistory
{

    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity="Order", inversedBy="orderHistorys", cascade={"persist"})
     */
    private $order;

    /**
     * @ORM\ManyToOne(targetEntity="RefOrderStatus", inversedBy="orderHistorysOld", cascade={"persist"})
     */
    private $old_status;

    /**
     * @ORM\ManyToOne(targetEntity="RefOrderStatus", inversedBy="orderHistorysNew", cascade={"persist"})
     */
    private $new_status;

    /**
     * @ORM\ManyToOne(targetEntity="User", inversedBy="orderHistorys", cascade={"persist"})
     * @ORM\JoinColumn(onDelete="SET NULL")
     */
    private $user;

    /**
     * @ORM\Column(name="date", type="datetime", nullable=false)
     */
    private $date;

    public function getId()
    {
        return $this->id;
    }

    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }

    public function getOrder()
    {
        return $this->order;
    }

    public function setOrder($order)
    {
        $this->order = $order;
        return $this;
    }

    public function getOldStatus()
    {
        return $this->old_status;
    }

    public function setOldStatus($old_status)
    {
        $this->old_status = $old_status;
        return $this;
    }

    public function getNewStatus()
    {
        return $this->new_status;
    }

    public function setNewStatus($new_status)
    {
        $this->new_status = $new_status;
        return $this;
    }

    public function getUser()
    {
        return $this->user;
    }

    public function setUser($user)
    {
        $this->user = $user;
        return $this;
    }

    public function getDate()
    {
        return $this->date;
    }

    public function setDate($date)
    {
        $this->date = $date;
        return $this;
    }

    public function __construct()
    {
        $this->date = new \DateTime();
    }

}