<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass="AppBundle\Repository\OrderRepository")
 * @ORM\Table(name="`order`")
 */
class Order
{

    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\Column(name="amount_ht", type="float", nullable=true)
     */
    private $amount_ht;

    /**
     * @ORM\Column(name="amount_tva", type="float", nullable=true)
     */
    private $amount_tva;

    /**
     * @ORM\Column(name="amount_ttc", type="float", nullable=true)
     */
    private $amount_ttc;

    /**
     * @ORM\ManyToOne(targetEntity="Company", inversedBy="orders", cascade={"persist"})
     */
    private $company;

    /**
     * @ORM\ManyToOne(targetEntity="User", inversedBy="orders", cascade={"persist"})
     * @ORM\JoinColumn(onDelete="SET NULL")
     */
    private $user;

    /**
     * @ORM\ManyToOne(targetEntity="RefOrderStatus", inversedBy="orders", cascade={"persist"})
     */
    private $status;

    /**
     * @ORM\Column(name="created_at", type="datetime", nullable=true)
     */
    private $created_at;

    /**
     * @ORM\Column(name="validated_at", type="datetime", nullable=true)
     */
    private $validated_at;

    /**
     * @ORM\OneToMany(targetEntity="OrderDetails", mappedBy="order", cascade={"remove"})
     */
    private $orderDetails;

    /**
     * @ORM\OneToMany(targetEntity="OrderHistory", mappedBy="order", cascade={"remove"})
     */
    private $orderHistorys;

    /**
     * @ORM\OneToMany(targetEntity="AccessibilityRegister", mappedBy="order")
     */
    private $accessibilityRegisters;

    /**
     * @ORM\OneToMany(targetEntity="PrintRequest", mappedBy="order")
     */
    private $printRequests;

    /**
     * @ORM\OneToOne(targetEntity="Transaction", mappedBy="order")
     */
    private $transaction;

    /**
     * @ORM\OneToOne(targetEntity="Invoice", mappedBy="order")
     */
    private $invoice;

    /**
     * @var string
     *
     * @ORM\Column(name="delivery_choice", type="string", length=255, nullable=true)
     */
    private $delivery_choice;

    /**
     * @ORM\ManyToOne(targetEntity="DeliveryAddress", inversedBy="orders", cascade={"persist"})
     */
    private $deliveryAddress;

    /**
     * @ORM\OneToMany(targetEntity="Subscription", mappedBy="order")
     */
    private $subscriptions;

    /**
     * @ORM\OneToMany(targetEntity="CoinsHistory", mappedBy="order")
     */
    private $coinsHistorys;

    /**
     * @ORM\OneToMany(targetEntity="QrCodeRequest", mappedBy="order")
     */
    private $qrCodeRequests;

    /**
     * @ORM\OneToMany(targetEntity="Relance", mappedBy="order")
     */
    private $relances;

    public function getId()
    {
        return $this->id;
    }

    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }

    public function getAmountHt()
    {
        return $this->amount_ht;
    }

    public function setAmountHt($amount_ht)
    {
        $this->amount_ht = $amount_ht;
        return $this;
    }

    public function getAmountTva()
    {
        return $this->amount_tva;
    }

    public function setAmountTva($amount_tva)
    {
        $this->amount_tva = $amount_tva;
        return $this;
    }

    public function getAmountTtc()
    {
        return $this->amount_ttc;
    }

    public function setAmountTtc($amount_ttc)
    {
        $this->amount_ttc = $amount_ttc;
        return $this;
    }

    public function getCompany()
    {
        return $this->company;
    }

    public function setCompany($company)
    {
        $this->company = $company;
        return $this;
    }

    public function getUser()
    {
        return $this->user;
    }

    public function setUser($user)
    {
        $this->user = $user;
        return $this;
    }

    public function getStatus()
    {
        return $this->status;
    }

    public function setStatus($status)
    {
        $this->status = $status;
        return $this;
    }

    public function getCreatedAt()
    {
        return $this->created_at;
    }

    public function setCreatedAt($created_at)
    {
        $this->created_at = $created_at;
        return $this;
    }

    public function getValidatedAt()
    {
        return $this->validated_at;
    }

    public function setValidatedAt($validated_at)
    {
        $this->validated_at = $validated_at;
        return $this;
    }

    public function getOrderDetails()
    {
        return $this->orderDetails;
    }

    public function setOrderDetails($orderDetails)
    {
        $this->orderDetails = $orderDetails;
        return $this;
    }

    public function getOrderHistorys()
    {
        return $this->orderHistorys;
    }

    public function setOrderHistorys($orderHistorys)
    {
        $this->orderHistorys = $orderHistorys;
        return $this;
    }

    public function getAccessibilityRegisters()
    {
        return $this->accessibilityRegisters;
    }

    public function setAccessibilityRegisters($accessibilityRegisters)
    {
        $this->accessibilityRegisters = $accessibilityRegisters;
        return $this;
    }

    public function getPrintRequests()
    {
        return $this->printRequests;
    }

    public function setPrintRequests($printRequests)
    {
        $this->printRequests = $printRequests;
        return $this;
    }

    public function getTransaction()
    {
        return $this->transaction;
    }

    public function setTransaction($transaction)
    {
        $this->transaction = $transaction;
        return $this;
    }

    public function __construct()
    {
        $this->created_at = new \DateTime();
    }

    public function getInvoice()
    {
        return $this->invoice;
    }

    public function setInvoice($invoice)
    {
        $this->invoice = $invoice;
        return $this;
    }

    public function getDeliveryAddress()
    {
        return $this->deliveryAddress;
    }

    public function setDeliveryAddress($deliveryAddress)
    {
        $this->deliveryAddress = $deliveryAddress;
        return $this;
    }

    public function getDeliveryChoice()
    {
        return $this->delivery_choice;
    }

    public function setDeliveryChoice($delivery_choice)
    {
        $this->delivery_choice = $delivery_choice;
        return $this;
    }

    public function getSubscriptions()
    {
        return $this->subscriptions;
    }

    public function setSubscriptions($subscriptions)
    {
        $this->subscriptions = $subscriptions;
        return $this;
    }

    public function getCoinsHistorys()
    {
        return $this->coinsHistorys;
    }

    public function setCoinsHistorys($coinsHistorys)
    {
        $this->coinsHistorys = $coinsHistorys;
        return $this;
    }

    public function getQrCodeRequests()
    {
        return $this->qrCodeRequests;
    }

    public function setQrCodeRequests($qrCodeRequests)
    {
        $this->qrCodeRequests = $qrCodeRequests;
        return $this;
    }

    public function getRelances()
    {
        return $this->relances;
    }

    public function setRelances($relances)
    {
        $this->relances = $relances;
        return $this;
    }
}