<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity
 * @ORM\Table(name="`navigation_menu`")
 */
class NavigationMenu
{

    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="title", type="string", length=255, nullable=false)
     */
    private $title;

    /**
     * @var string
     *
     * @ORM\Column(name="custom_link", type="string", length=255, nullable=true)
     */
    private $custom_link;

    /**
     * @var integer
     *
     * @ORM\Column(name="`order`", type="string", length=255, nullable=true)
     */
    private $order;

    /**
     * @ORM\ManyToOne(targetEntity="Post", inversedBy="navigationMenus", cascade={"persist"})
     * @ORM\JoinColumn(onDelete="CASCADE")
     */
    private $post;

    public function getId()
    {
        return $this->id;
    }

    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }

    public function getTitle()
    {
        return $this->title;
    }

    public function setTitle($title)
    {
        $this->title = $title;
        return $this;
    }

    public function getCustomLink()
    {
        return $this->custom_link;
    }

    public function setCustomLink($custom_link)
    {
        $this->custom_link = $custom_link;
        return $this;
    }

    public function getOrder()
    {
        return $this->order;
    }

    public function setOrder($order)
    {
        $this->order = $order;
        return $this;
    }

    public function getPost()
    {
        return $this->post;
    }

    public function setPost($post)
    {
        $this->post = $post;
        return $this;
    }




}