<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

/**
 * @ORM\Entity
 */
class Mail
{

    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="subject", type="string", length=255, nullable=false)
     */
    private $subject;

    /**
     *
     * @ORM\Column(name="content", type="text", nullable=false)
     */
    private $content;

    /**
     *
     * @ORM\Column(name="nb_of_emails", type="integer", nullable=true)
     */
    private $nb_of_emails;

    /**
     * @ORM\ManyToOne(targetEntity="MailType", inversedBy="mails", cascade={"persist"})
     */
    private $mailType;

    /**
     * @ORM\ManyToMany(targetEntity="Company", inversedBy="mails", cascade={"persist"})
     */
    private $companies;

    /**
     * @ORM\Column(name="created_at", type="datetime", nullable=true)
     */
    private $created_at;

    public function getId()
    {
        return $this->id;
    }

    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }

    public function getSubject()
    {
        return $this->subject;
    }

    public function setSubject($subject)
    {
        $this->subject = $subject;
        return $this;
    }

    public function getContent()
    {
        return $this->content;
    }

    public function setContent($content)
    {
        $this->content = $content;
        return $this;
    }

    public function getNbOfEmails()
    {
        return $this->nb_of_emails;
    }

    public function setNbOfEmails($nb_of_emails)
    {
        $this->nb_of_emails = $nb_of_emails;
        return $this;
    }

    public function getMailType()
    {
        return $this->mailType;
    }

    public function setMailType($mailType)
    {
        $this->mailType = $mailType;
        return $this;
    }

    public function getCompanies()
    {
        return $this->companies;
    }

    public function setCompanies($companies)
    {
        $this->companies = $companies;
        return $this;
    }

    public function addCompany(Company $company)
    {
        $this->companies[] = $company;
    }

    public function getCreatedAt()
    {
        return $this->created_at;
    }

    public function setCreatedAt($created_at)
    {
        $this->created_at = $created_at;
        return $this;
    }

    public function __construct()
    {
        $this->created_at = new \DateTime();
    }

}