<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Doctrine\ORM\Mapping\QuoteStrategy;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * @ORM\Entity
 */
class FileUpload
{

    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="name", type="string", length=255, nullable=false)
     */
    private $name;

    /**
     * @var string
     *
     * @ORM\Column(name="path", type="string", length=255, nullable=false)
     *
     */
    private $path;

    /**
     * @ORM\Column(name="`order`", type="integer", length=255, nullable=false)
     */
    private $order;

    /**
     * @ORM\ManyToMany(targetEntity="AccessibilityRegister", mappedBy="fileUploads", cascade={"persist"})
     */
    private $accessibilityRegisters;

    /**
     * @ORM\ManyToOne(targetEntity="RefTypeFile", inversedBy="fileUploads", cascade={"persist"})
     */
    private $fileType;

    /**
     * @ORM\ManyToOne(targetEntity="Erp", inversedBy="fileUploads", cascade={"persist"})
     */
    private $erp;

    public function getId()
    {
        return $this->id;
    }

    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }

    public function getName()
    {
        return $this->name;
    }

    public function setName($name)
    {
        $this->name = $name;
        return $this;
    }

    public function getPath()
    {
        return $this->path;
    }

    public function setPath($path)
    {
        $this->path = $path;
        return $this;
    }

    public function getOrder()
    {
        return $this->order;
    }

    public function setOrder($order)
    {
        $this->order = $order;
        return $this;
    }


    public function getFileType()
    {
        return $this->fileType;
    }

    public function setFileType($fileType)
    {
        $this->fileType = $fileType;
        return $this;
    }

    public function getAccessibilityRegisters()
    {
        return $this->accessibilityRegisters;
    }

    public function setAccessibilityRegisters($accessibilityRegisters)
    {
        $this->accessibilityRegisters = $accessibilityRegisters;
        return $this;
    }

    public function addAccessibilityRegister(AccessibilityRegister $accessibilityRegister)
    {
        $this->accessibilityRegisters[] = $accessibilityRegister;
    }

    public function removeAccessibilityRegister(AccessibilityRegister $accessibilityRegister)
    {
        return $this->accessibilityRegisters->removeElement($accessibilityRegister);
    }

    public function getErp()
    {
        return $this->erp;
    }

    public function setErp($erp)
    {
        $this->erp = $erp;
        return $this;
    }


}