<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

/**
 * @ORM\Entity(repositoryClass="AppBundle\Repository\ErpRepository")
 */
class Erp
{

    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="name", type="string", length=255, nullable=false)
     */
    private $name;

    /**
     * @var string
     *
     * @Gedmo\Slug(fields={"name", "postalCode"})
     * @ORM\Column(name="slug", type="string", length=255, nullable=false, unique=true)
     */
    private $slug;

    /**
     * @var string
     *
     * @ORM\Column(name="siret", type="string", length=255, nullable=false)
     */
    private $siret;

    /**
     * @var string
     *
     * @ORM\Column(name="address_1", type="string", length=255, nullable=false)
     */
    private $address1;

    /**
     * @var string
     *
     * @ORM\Column(name="address_2", type="string", length=255, nullable=true)
     */
    private $address2;

    /**
     * @var string
     *
     * @ORM\Column(name="postal_code", type="string", length=255, nullable=false)
     */
    private $postalCode;

    /**
     * @var string
     *
     * @ORM\Column(name="city", type="string", length=255, nullable=false)
     */
    private $city;

    /**
     * @ORM\ManyToOne(targetEntity="Company", inversedBy="erps", cascade={"persist"})
     */
    private $company;

    /**
     * @ORM\ManyToOne(targetEntity="RefCategoryErp", inversedBy="erps", cascade={"persist"})
     */
    private $categoryErp;

    /**
     * @ORM\ManyToOne(targetEntity="RefTypeErp", inversedBy="erps", cascade={"persist"})
     */
    private $typeErp;

    /**
     * @ORM\OneToMany(targetEntity="AccessibilityRegister", mappedBy="erp", cascade={"remove"})
     */
    private $accessibilityRegisters;

    /**
     * @ORM\OneToMany(targetEntity="FileUpload", mappedBy="erp", cascade={"remove"})
     */
    private $fileUploads;

    /**
     * @ORM\OneToMany(targetEntity="Subscription", mappedBy="erp")
     */
    private $subscriptions;

    /**
     * @ORM\OneToMany(targetEntity="BonusParrainage", mappedBy="erp_beneficiary")
     */
    private $bonusParrainages;

    /**
     * @ORM\Column(name="created_at", type="datetime", nullable=true)
     */
    private $created_at;

    public function getId()
    {
        return $this->id;
    }

    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }

    public function getName()
    {
        return $this->name;
    }

    public function setName($name)
    {
        $this->name = $name;
        return $this;
    }

    public function getSlug()
    {
        return $this->slug;
    }

    public function setSlug($slug)
    {
        $this->slug = $slug;
        return $this;
    }

    public function getSiret()
    {
        return $this->siret;
    }

    public function setSiret($siret)
    {
        $this->siret = $siret;
        return $this;
    }

    public function getAddress1()
    {
        return $this->address1;
    }

    public function setAddress1($address1)
    {
        $this->address1 = $address1;
        return $this;
    }

    public function getAddress2()
    {
        return $this->address2;
    }

    public function setAddress2($address2)
    {
        $this->address2 = $address2;
        return $this;
    }

    public function getPostalCode()
    {
        return $this->postalCode;
    }

    public function setPostalCode($postalCode)
    {
        $this->postalCode = $postalCode;
        return $this;
    }

    public function getCity()
    {
        return $this->city;
    }

    public function setCity($city)
    {
        $this->city = $city;
        return $this;
    }

    public function getCompany()
    {
        return $this->company;
    }

    public function setCompany($company)
    {
        $this->company = $company;
        return $this;
    }

    public function getCategoryErp()
    {
        return $this->categoryErp;
    }

    public function setCategoryErp($categoryErp)
    {
        $this->categoryErp = $categoryErp;
        return $this;
    }

    public function getTypeErp()
    {
        return $this->typeErp;
    }

    public function setTypeErp($typeErp)
    {
        $this->typeErp = $typeErp;
        return $this;
    }

    public function getAccessibilityRegisters()
    {
        return $this->accessibilityRegisters;
    }

    public function setAccessibilityRegisters($accessibilityRegisters)
    {
        $this->accessibilityRegisters = $accessibilityRegisters;
        return $this;
    }

    public function getFileUploads()
    {
        return $this->fileUploads;
    }

    public function setFileUploads($fileUploads)
    {
        $this->fileUploads = $fileUploads;
        return $this;
    }

    public function getSubscriptions()
    {
        return $this->subscriptions;
    }

    public function setSubscriptions($subscriptions)
    {
        $this->subscriptions = $subscriptions;
        return $this;
    }

    public function getBonusParrainages()
    {
        return $this->bonusParrainages;
    }

    public function setBonusParrainages($bonusParrainages)
    {
        $this->bonusParrainages = $bonusParrainages;
        return $this;
    }

    public function getCreatedAt()
    {
        return $this->created_at;
    }

    public function setCreatedAt($created_at)
    {
        $this->created_at = $created_at;
        return $this;
    }

    public function __construct()
    {
        $this->created_at = new \DateTime();
    }

}