<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass="AppBundle\Repository\CompanyRepository")
 */
class Company
{

    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="name", type="string", length=255, nullable=false)
     */
    private $name;

    /**
     * @var string
     *
     * @ORM\Column(name="siren", type="string", length=255, nullable=false)
     */
    private $siren;

    /**
     * @var string
     *
     * @ORM\Column(name="address_1", type="string", length=255, nullable=false)
     */
    private $address1;

    /**
     * @var string
     *
     * @ORM\Column(name="address_2", type="string", length=255, nullable=true)
     */
    private $address2;

    /**
     * @var string
     *
     * @ORM\Column(name="postal_code", type="string", length=255, nullable=false)
     */
    private $postalCode;

    /**
     * @var string
     *
     * @ORM\Column(name="city", type="string", length=255, nullable=false)
     */
    private $city;

    /**
     * @ORM\OneToMany(targetEntity="User", mappedBy="company", cascade={"remove"})
     */
    private $users;

    /**
     * @ORM\OneToMany(targetEntity="Erp", mappedBy="company", cascade={"remove"})
     */
    private $erps;

    /**
     * @ORM\OneToMany(targetEntity="Order", mappedBy="company", cascade={"remove"})
     */
    private $orders;

    /**
     * @ORM\OneToMany(targetEntity="DeliveryAddress", mappedBy="company")
     */
    private $deliveryAddresses;

    /**
     * @ORM\OneToMany(targetEntity="Invoice", mappedBy="company")
     */
    private $invoices;

    /**
     * @ORM\OneToMany(targetEntity="CoinsHistory", mappedBy="company")
     */
    private $coinsHistorys;

    /**
     * @var string
     *
     * @ORM\Column(name="coins", type="integer", nullable=true)
     */
    private $coins;

    /**
     * @var string
     *
     * @ORM\Column(name="role", type="string", length=255, nullable=true)
     */
    private $role;

    /**
     * @ORM\ManyToMany(targetEntity="Mail", mappedBy="companies", cascade={"persist"})
     */
    private $mails;

    /**
     * @ORM\OneToMany(targetEntity="Company", mappedBy="parrain")
     */
    private $filleuls;

    /**
     * @ORM\ManyToOne(targetEntity="Company", inversedBy="filleuls")
     * @ORM\JoinColumn(name="parrain_id", referencedColumnName="id")
     */
    private $parrain;

    /**
     * @var string
     *
     * @ORM\Column(name="code_parrainage", type="string", length=255, nullable=true)
     */
    private $code_parrainage;

    /**
     * @ORM\OneToMany(targetEntity="BonusParrainage", mappedBy="filleul")
     */
    private $bonusParrainagesFilleuls;

    /**
     * @ORM\OneToMany(targetEntity="BonusParrainage", mappedBy="parrain")
     */
    private $bonusParrainagesParrains;

    /**
     * @ORM\Column(name="created_at", type="datetime", nullable=true)
     */
    private $created_at;

    public function getId()
    {
        return $this->id;
    }

    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }

    public function getName()
    {
        return $this->name;
    }

    public function setName($name)
    {
        $this->name = $name;
        return $this;
    }

    public function getSiren()
    {
        return $this->siren;
    }

    public function setSiren($siren)
    {
        $this->siren = $siren;
        return $this;
    }

    public function getAddress1()
    {
        return $this->address1;
    }

    public function setAddress1($address1)
    {
        $this->address1 = $address1;
        return $this;
    }

    public function getAddress2()
    {
        return $this->address2;
    }

    public function setAddress2($address2)
    {
        $this->address2 = $address2;
        return $this;
    }

    public function getPostalCode()
    {
        return $this->postalCode;
    }

    public function setPostalCode($postalCode)
    {
        $this->postalCode = $postalCode;
        return $this;
    }

    public function getCity()
    {
        return $this->city;
    }

    public function setCity($city)
    {
        $this->city = $city;
        return $this;
    }

    public function getUsers()
    {
        return $this->users;
    }

    public function setUsers($users)
    {
        $this->users = $users;
        return $this;
    }

    public function getErps()
    {
        return $this->erps;
    }

    public function setErps($erps)
    {
        $this->erps = $erps;
        return $this;
    }

    public function getOrders()
    {
        return $this->orders;
    }

    public function setOrders($orders)
    {
        $this->orders = $orders;
        return $this;
    }

    public function getDeliveryAddresses()
    {
        return $this->deliveryAddresses;
    }

    public function setDeliveryAddresses($deliveryAddresses)
    {
        $this->deliveryAddresses = $deliveryAddresses;
        return $this;
    }

    public function getInvoices()
    {
        return $this->invoices;
    }

    public function setInvoices($invoices)
    {
        $this->invoices = $invoices;
        return $this;
    }

    public function getCoins()
    {
        return $this->coins;
    }

    public function setCoins($coins)
    {
        $this->coins = $coins;
        return $this;
    }

    public function getRole()
    {
        return $this->role;
    }

    public function setRole($role)
    {
        $this->role = $role;
        return $this;
    }

    public function getCoinsHistorys()
    {
        return $this->coinsHistorys;
    }

    public function setCoinsHistorys($coinsHistorys)
    {
        $this->coinsHistorys = $coinsHistorys;
        return $this;
    }

    public function getMails()
    {
        return $this->mails;
    }

    public function setMails($mails)
    {
        $this->mails = $mails;
        return $this;
    }

    public function addMail(Mail $mail)
    {
        $this->mails[] = $mail;
    }

    public function getFilleuls()
    {
        return $this->filleuls;
    }

    public function setFilleuls($filleuls)
    {
        $this->filleuls = $filleuls;
        return $this;
    }

    public function getParrain()
    {
        return $this->parrain;
    }

    public function setParrain($parrain)
    {
        $this->parrain = $parrain;
        return $this;
    }

    public function getCodeParrainage()
    {
        return $this->code_parrainage;
    }

    public function setCodeParrainage($code_parrainage)
    {
        $this->code_parrainage = $code_parrainage;
        return $this;
    }

    public function getBonusParrainagesFilleuls()
    {
        return $this->bonusParrainagesFilleuls;
    }

    public function setBonusParrainagesFilleuls($bonusParrainagesFilleuls)
    {
        $this->bonusParrainagesFilleuls = $bonusParrainagesFilleuls;
        return $this;
    }

    public function getBonusParrainagesParrains()
    {
        return $this->bonusParrainagesParrains;
    }

    public function setBonusParrainagesParrains($bonusParrainagesParrains)
    {
        $this->bonusParrainagesParrains = $bonusParrainagesParrains;
        return $this;
    }

    public function getCreatedAt()
    {
        return $this->created_at;
    }

    public function setCreatedAt($created_at)
    {
        $this->created_at = $created_at;
        return $this;
    }

    public function __construct()
    {
        $this->created_at = new \DateTime();
    }

}