<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity
 */
class CoinsHistory
{

    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity="Company", inversedBy="coinsHistorys", cascade={"persist"})
     */
    private $company;

    /**
     * @ORM\ManyToOne(targetEntity="Order", inversedBy="coinsHistorys", cascade={"persist"})
     */
    private $order;

    /**
     * @ORM\ManyToOne(targetEntity="User", inversedBy="coinsHistorys", cascade={"persist"})
     * @ORM\JoinColumn(onDelete="SET NULL")
     */
    private $user;

    /**
     * @ORM\Column(name="date", type="datetime", nullable=false)
     */
    private $date;

    /**
     * @ORM\Column(name="operation", type="string", length=255, nullable=true)
     */
    private $operation;

    /**
     * @ORM\Column(name="movement_type", type="string", length=255, nullable=false)
     */
    private $movement_type;

    /**
     * @ORM\Column(name="old_balance", type="integer", nullable=false)
     */
    private $old_balance;

    /**
     * @ORM\Column(name="new_balance", type="integer", nullable=false)
     */
    private $new_balance;

    public function getId()
    {
        return $this->id;
    }

    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }

    public function getCompany()
    {
        return $this->company;
    }

    public function setCompany($company)
    {
        $this->company = $company;
        return $this;
    }

    public function getOrder()
    {
        return $this->order;
    }

    public function setOrder($order)
    {
        $this->order = $order;
        return $this;
    }

    public function getUser()
    {
        return $this->user;
    }

    public function setUser($user)
    {
        $this->user = $user;
        return $this;
    }

    public function getDate()
    {
        return $this->date;
    }

    public function setDate($date)
    {
        $this->date = $date;
        return $this;
    }

    public function getOperation()
    {
        return $this->operation;
    }

    public function setOperation($operation)
    {
        $this->operation = $operation;
        return $this;
    }

    public function getMovementType()
    {
        return $this->movement_type;
    }

    public function setMovementType($movement_type)
    {
        $this->movement_type = $movement_type;
        return $this;
    }

    public function getNewBalance()
    {
        return $this->new_balance;
    }

    public function setNewBalance($new_balance)
    {
        $this->new_balance = $new_balance;
        return $this;
    }

    public function getOldBalance()
    {
        return $this->old_balance;
    }

    public function setOldBalance($old_balance)
    {
        $this->old_balance = $old_balance;
        return $this;
    }

    public function __construct()
    {
        $this->date = new \DateTime();
    }

}