<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass="AppBundle\Repository\BonusParrainageRepository")
 */
class BonusParrainage
{

    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity="Company", inversedBy="bonusParrainagesFilleuls", cascade={"persist"})
     */
    private $filleul;

    /**
     * @ORM\ManyToOne(targetEntity="Company", inversedBy="bonusParrainagesParrains", cascade={"persist"})
     */
    private $parrain;

    /**
     * @ORM\ManyToOne(targetEntity="Erp", inversedBy="bonusParrainages", cascade={"persist"})
     */
    private $erp_beneficiary;

    /**
     * @ORM\Column(name="created_at", type="datetime", nullable=true)
     */
    private $created_at;

    /**
     * @ORM\Column(name="activated_at", type="datetime", nullable=true)
     */
    private $activated_at;

    public function getId()
    {
        return $this->id;
    }

    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }

    public function getFilleul()
    {
        return $this->filleul;
    }

    public function setFilleul($filleul)
    {
        $this->filleul = $filleul;
        return $this;
    }

    public function getParrain()
    {
        return $this->parrain;
    }

    public function setParrain($parrain)
    {
        $this->parrain = $parrain;
        return $this;
    }

    public function getErpBeneficiary()
    {
        return $this->erp_beneficiary;
    }

    public function setErpBeneficiary($erp_beneficiary)
    {
        $this->erp_beneficiary = $erp_beneficiary;
        return $this;
    }

    public function getCreatedAt()
    {
        return $this->created_at;
    }

    public function setCreatedAt($created_at)
    {
        $this->created_at = $created_at;
        return $this;
    }

    public function getActivatedAt()
    {
        return $this->activated_at;
    }

    public function setActivatedAt($activated_at)
    {
        $this->activated_at = $activated_at;
        return $this;
    }

    public function __construct()
    {
        $this->created_at = new \DateTime();
    }

}