<?php

namespace AppBundle\Entity;

use AppBundle\Entity\FileUpload;
use AppBundle\Repository\FileUploadRepository;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Entity(repositoryClass="AppBundle\Repository\AccessibilityRegisterRepository")
 */
class AccessibilityRegister
{

    /**
     * @ORM\Id
     * @ORM\Column(type="integer")
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity="Erp", inversedBy="accessibilityRegisters", cascade={"persist"})
     */
    private $erp;

    /**
     * @ORM\ManyToMany(targetEntity="FileUpload", inversedBy="accessibilityRegisters", cascade={"persist"})
     */
    private $fileUploads;

    /**
     * @ORM\Column(name="created_at", type="datetime", nullable=true)
     */
    private $created_at;

    /**
     * @ORM\Column(name="updated_at", type="datetime", nullable=true)
     */
    private $updated_at;

    /**
     * @ORM\Column(name="generated_at", type="datetime", nullable=true)
     */
    private $generated_at;

    /**
     * @var string
     *
     * @ORM\Column(name="pdf", type="string", length=255, nullable=true)
     */
    private $pdf;

    /**
     * @var string
     *
     * @ORM\Column(name="validation_status", type="string", length=255, nullable=true)
     */
    private $validation_status;

    /**
     * One Category has Many Categories.
     * @ORM\OneToMany(targetEntity="AccessibilityRegister", mappedBy="parent")
     */
    private $children;

    /**
     * @ORM\ManyToOne(targetEntity="AccessibilityRegister", inversedBy="children")
     * @ORM\JoinColumn(name="parent_id", referencedColumnName="id")
     */
    private $parent;

    /**
     * @ORM\ManyToOne(targetEntity="Order", inversedBy="accessibilityRegisters", cascade={"persist"})
     */
    private $order;

    /**
     * @var string
     *
     * @ORM\Column(name="token", type="string", length=255, nullable=true)
     */
    private $token;

    /**
     *
     * @ORM\Column(name="allow_pdf", type="string", length=255, nullable=true)
     */
    private $allow_pdf;

    /**
     * @ORM\Column(name="validated_at", type="datetime", nullable=true)
     */
    private $validated_at;

    /**
     * @ORM\Column(name="checked_at", type="datetime", nullable=true)
     */
    private $checked_at;

    /**
     * @ORM\OneToMany(targetEntity="Exchange", mappedBy="register")
     */
    private $exchanges;

    /**
     * @ORM\OneToOne(targetEntity="PrintRequest", mappedBy="register")
     */
    private $printRequest;

    /**
     * @ORM\OneToOne(targetEntity="QrCodeRequest", mappedBy="register")
     */
    private $qrCodeRequest;

    /**
     * @ORM\OneToOne(targetEntity="QrCode", inversedBy="register")
     */
    private $qrCode;

    public function getId()
    {
        return $this->id;
    }

    public function setId($id)
    {
        $this->id = $id;
        return $this;
    }

    public function getErp()
    {
        return $this->erp;
    }

    public function setErp($erp)
    {
        $this->erp = $erp;
        return $this;
    }

    public function getFileUploads()
    {
        return $this->fileUploads;
    }

    public function setFileUploads($fileUploads)
    {
        $this->fileUploads = $fileUploads;
        return $this;
    }

    public function getOrderedFileUploads()
    {
        $files = $this->getFileUploads()->toArray();
        usort($files, function ($a, $b) {
            if ($a->getFileType()->getId() == $b->getFileType()->getId()) {
                if($a->getOrder() == $b->getOrder()){
                    return 0;
                }elseif($a->getOrder() < $b->getOrder()){
                    return -1;
                }
                return 1;
            }
            elseif ($a->getFileType()->getId() < $b->getFileType()->getId()){
                return -1;

            }
            return 1;
        });

        return $files;

    }

    public function getFileUploadsByTypeId($typeId)
    {
        $files = [];

        if(!is_null($this->getFileUploads()))
        {
            foreach ($this->getFileUploads() as $file)
            {
                if($file->getFileType()->getId() == $typeId)
                {
                    $files[] = $file;
                }
            }
        }
        return $files;
    }

    public function getCreatedAt()
    {
        return $this->created_at;
    }

    public function setCreatedAt($created_at)
    {
        $this->created_at = $created_at;
        return $this;
    }

    public function getUpdatedAt()
    {
        return $this->updated_at;
    }

    public function setUpdatedAt($updated_at)
    {
        $this->updated_at = $updated_at;
        return $this;
    }

    public function getGeneratedAt()
    {
        return $this->generated_at;
    }

    public function setGeneratedAt($generated_at)
    {
        $this->generated_at = $generated_at;
        return $this;
    }

    public function getPdf()
    {
        return $this->pdf;
    }

    public function setPdf($pdf)
    {
        $this->pdf = $pdf;
        return $this;
    }

    public function getQrCode()
    {
        return $this->qrCode;
    }

    public function setQrCode($qrCode)
    {
        $this->qrCode = $qrCode;
        return $this;
    }

    public function getOrder()
    {
        return $this->order;
    }

    public function setOrder($order)
    {
        $this->order = $order;
        return $this;
    }

    public function getToken()
    {
        return $this->token;
    }

    public function setToken($token)
    {
        $this->token = $token;
        return $this;
    }

    public function getValidatedAt()
    {
        return $this->validated_at;
    }

    public function setValidatedAt($validated_at)
    {
        $this->validated_at = $validated_at;
        return $this;
    }

    public function addFileUpload(\AppBundle\Entity\FileUpload $fileUpload)
    {
        $this->fileUploads[] = $fileUpload;
    }

    public function removeFileUpload(\AppBundle\Entity\FileUpload $fileUpload)
    {
        return $this->fileUploads->removeElement($fileUpload);
    }

    public function getValidationStatus()
    {
        return $this->validation_status;
    }

    public function setValidationStatus($validation_status)
    {
        $this->validation_status = $validation_status;
        return $this;
    }

    public function getParent()
    {
        return $this->parent;
    }

    public function setParent($parent)
    {
        $this->parent = $parent;
        return $this;
    }

    public function getExchanges()
    {
        return $this->exchanges;
    }

    public function setExchanges($exchanges)
    {
        $this->exchanges = $exchanges;
        return $this;
    }

    public function getCheckedAt()
    {
        return $this->checked_at;
    }

    public function setCheckedAt($checked_at)
    {
        $this->checked_at = $checked_at;
        return $this;
    }

    public function getChildren()
    {
        return $this->children;
    }

    public function setChildren($children)
    {
        $this->children = $children;
        return $this;
    }

    public function getPrintRequest()
    {
        return $this->printRequest;
    }

    public function setPrintRequest($printRequest)
    {
        $this->printRequest = $printRequest;
        return $this;
    }

    public function getAllowPdf()
    {
        return $this->allow_pdf;
    }

    public function setAllowPdf($allow_pdf)
    {
        $this->allow_pdf = $allow_pdf;
        return $this;
    }

    public function getQrCodeRequest()
    {
        return $this->qrCodeRequest;
    }

    public function setQrCodeRequest($qrCodeRequest)
    {
        $this->qrCodeRequest = $qrCodeRequest;
        return $this;
    }

    public function __construct()
    {
        $this->created_at = new \DateTime();
        $this->children = new \Doctrine\Common\Collections\ArrayCollection();
    }


}