<?php

namespace AppBundle\Controller;

use AppBundle\Entity\QrCode;
use AppBundle\Entity\QrCodeRequest;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Spipu\Html2Pdf\Html2Pdf;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Endroid\QrCode\QrCode as QrCodePng;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;

class DefaultController extends Controller
{
    /**
     * @Route("/admin/generate-qr-codes", name="generate_qr_codes")
     */
    public function GenerateMultipleQrCodesAction()
    {
        $lastQrCode = $this->getDoctrine()->getRepository(QrCode::class)->findOneBy([], ['hash' => 'DESC']);
        $hash = $lastQrCode->getHash() + 1;

        $em = $this->getDoctrine()->getManager();

        $qrCode = new QrCode();
        $qrCode->setHash($hash);
        $em->persist($qrCode);
        $em->flush();

        $qrCodePng = new QrCodePng($this->generateUrl('qrCode_redirect', ['hash' => $hash], UrlGeneratorInterface::ABSOLUTE_URL));
        $qrCodePng->writeFile($this->getParameter('qrcodes_directory').'qrcode-'.$qrCode->getHash().'.png');
        $qrCodePath = 'qrcode-'.$qrCode->getHash().'.png';

        require_once(__DIR__.'/../../../vendor/autoload.php');
        $html2pdf = new Html2Pdf();
        $html2pdf->writeHTML($this->renderView('Pdf/qr_code.html.twig', [
            'hash' => $hash,
            'qrcodepath' => $qrCodePath
        ]));

        $pdfname = 'qrcode-pdf-'.$qrCode->getHash().'.pdf';
        $html2pdf->output($this->getParameter('qrcodes_directory').'pdf/'.$pdfname, 'F');
        $qrCode->setPdf($pdfname);

        $em->persist($qrCode);
        $em->flush();

        return $this->redirectToRoute('generate_qr_codes');
    }

    /**
     * @Route("/admin/assign-qr-codes", name="assign_qr_codes")
     */
    public function AssignQrCodesAction()
    {

        $qrCodeRequests = $this->getDoctrine()->getRepository(QrCodeRequest::class)->findBy([], ['id' => 'ASC']);
        $em = $this->getDoctrine()->getManager();

        foreach ($qrCodeRequests as $qrCodeRequest) {

            $register = $qrCodeRequest->getRegister();
            if(!$register->getQrCode()) {
                $firstFreeQrCode = $this->getDoctrine()->getRepository(QrCode::class)->findByAvailableQrCode();
                $register->setQrCode($firstFreeQrCode);
                $firstFreeQrCode->setAssignedAt(new \DateTime());
                $em->persist($register);
                $em->persist($firstFreeQrCode);
                $em->flush();
            }
        }

        return $this->redirectToRoute('assign_qr_codes');
    }


}
