<?php

namespace AdminBundle\Form;

use AppBundle\Entity\Erp;
use AppBundle\Entity\PrintRequest;
use AppBundle\Entity\QrCodeRequest;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\NumberType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Validator\Constraints\NotBlank;

class QrCodeRequestType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('status', ChoiceType::class, [
                'label' => 'Statut',
                'choices'  => array(
                    'En attente' => 'pending',
                    'Envoyé' => 'send',
                ),

            ])
            ->add('save', SubmitType::class, [
                'label' => 'Mettre à jour le statut',
                'attr' => [
                    'class' => 'btn-primary btn-sm'
                ],
            ])
        ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => QrCodeRequest::class,
        ));
    }
}