<?php

namespace AdminBundle\Form;

use AppBundle\Entity\NavigationMenu;
use Symfony\Bridge\Doctrine\Form\Type\EntityType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\SubmitType;
use Symfony\Component\Form\Extension\Core\Type\UrlType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Validator\Constraints\NotBlank;

class NavigationMenuType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('title', TextType::class, [
                'label' => 'Titre du lien de navigation',
                'required' => true,
                'constraints' => [
                    new NotBlank()
                ]
            ])
            ->add('post', EntityType::class, [
                'class' => 'AppBundle:Post',
                'choice_label' => 'title',
                'placeholder' => 'Vers le contenu',
                'label' => 'Contenu ciblé',
                'required' => false,
            ])
            ->add('custom_link', UrlType::class, [
                'label' => 'Lien personnalisé',
                'required' => false
            ])
            ->add('save', SubmitType::class, [
                'label' => 'Enregistrer',
                'attr' => [
                    'class' => 'btn btn-primary'
                ]
            ])
        ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => NavigationMenu::class,
        ));
    }
}