<?php

namespace AdminBundle\Form;

use AppBundle\Entity\Company;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\NumberType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Validator\Constraints\NotBlank;

class AdminCompanyType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('name', TextType::class, [
                'label' => 'Nom de la société',
                'attr' => [
                    'placeholder' => 'Ex : Société'
                ],
                'required' => true,
                'constraints' => [
                    new NotBlank()
                ]
            ])
            ->add('siren', TextType::class, [
                'label' => 'N° SIREN',
                'attr' => [
                    'placeholder' => 'Ex: 0123456000034'
                ],
                'required' => true,
                'constraints' => [
                    new NotBlank()
                ]
            ])
            ->add('address_1', TextType::class, [
                'label' => 'Adresse de la société',
                'attr' => [
                    'placeholder' => 'Ex: 2 rue des coquelicots'
                ],
                'required' => true,
                'constraints' => [
                    new NotBlank()
                ]
            ])
            ->add('address_2', TextType::class, [
                'label' => 'Adresse (complémentaire)',
                'required' => false,
            ])
            ->add('role', ChoiceType::class, [
                'label' => 'Rôle',
                'choices'  => array(
                    'Compte standard' => 'standard',
                    'Grand compte' => 'large',
                ),
            ])
            ->add('postal_code', NumberType::class, [
                'label' => 'Code postal',
                'attr' => [
                    'placeholder' => 'Ex: 75000'
                ],
                'required' => true,
                'constraints' => [
                    new NotBlank()
                ]
            ])
            ->add('city', TextType::class, [
                'label' => 'Ville',
                'attr' => [
                    'placeholder' => 'Ex: Paris'
                ],
                'required' => true,
                'constraints' => [
                    new NotBlank()
                ]
            ])
        ;
    }

    public function configureOptions(OptionsResolver $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => Company::class,
        ));
    }
}